<?php
/**
 * The template for displaying wpdm archive pages
 */

$package = wpdm_get_package(get_the_ID());

get_header(); ?>

	<section id="primary" class="content-area">
		<main id="main" class="site-main" role="main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<?php
					the_archive_title( '<h1 class="page-title">', '</h1>' );
					the_archive_description( '<div class="taxonomy-description">', '</div>' );
				?>
			</header><!-- .page-header -->
            <div <?php post_class('w3eden archive-wpdmpro'); ?>>    
            
			<?php
			// Start the Loop.
			while ( have_posts() ) : the_post();

				?>
                    
                        <div class="panel panel-default">
                            <?php
                                // Post thumbnail.
                                twentyfifteen_post_thumbnail();
                            ?>
                           
                                <div class="panel-body">
                                    <?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
                                     
                                </div>
                            <div class="panel-footer">
                                <div class="row">
                                    <div class="col-md-3">
                                        <i class="fa fa-eye"></i> <?php echo get_package_data(get_the_ID(), 'view_count'). __( ' Views', 'twentyfifteen' ); ?>
                                    </div>
                                    <div class="col-md-3">
                                        <i class="fa fa-download"></i> <?php echo get_package_data(get_the_ID(), 'download_count'). __( ' Downloads', 'twentyfifteen' ); ?>
                                    </div>
                                    <div class="col-md-2">
                                        <i class="fa fa-cube"></i> <?php echo get_package_data(get_the_ID(), 'package_size'); ?>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="pull-right">
                <a class="btn btn-default btn-xs" href="<?php the_permalink(); ?>">View Details <i class="fa fa-long-arrow-right"></i></a>
            </div>
                                    </div>
                                </div>
                                 
                            </div>
                        </div>
                     
                <?php

			// End the loop.
			endwhile;
            ?>
             
            </div> 
            
            <?php
			// Previous/next page navigation.
			the_posts_pagination( array(
				'prev_text'          => __( 'Previous page', 'twentyfifteen' ),
				'next_text'          => __( 'Next page', 'twentyfifteen' ),
				'before_page_number' => '<span class="meta-nav screen-reader-text">' . __( 'Page', 'twentyfifteen' ) . ' </span>',
			) );

		// If no content, include the "No posts found" template.
		else :
			get_template_part( 'content', 'none' );

		endif;
		?>

		</main><!-- .site-main -->
	</section><!-- .content-area -->

<?php get_footer(); ?>
