<?php
/**
 * The template used for displaying download manager page content
 */

$package = wpdm_get_package(get_the_ID());
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php
		// Post thumbnail.
		twentyfifteen_post_thumbnail();
	?>

	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</header><!-- .entry-header -->
    
	<div class="entry-content w3eden">

        <ul class="list-group">
            <?php if(isset($package['version']) && $package['version']!=''){ ?>
            <li class="list-group-item"><span class="label label-info pull-right"><?php echo $package['version']; ?></span> <?php _e('Version','wpdmpro'); ?></li>
            <?php } ?>
            <?php if(isset($package['download_count']) && $package['download_count']>0){ ?>
                <li class="list-group-item"><span class="label label-info pull-right"><?php echo $package['download_count']; ?></span> <?php _e('Downloads','wpdmpro'); ?></li>
            <?php } ?>
            <li class="list-group-item"><span class="label label-info pull-right"><?php echo $package['package_size']; ?></span> <?php _e('Size','wpdmpro'); ?></li>
            <li class="list-group-item"><span class="label label-info pull-right"><?php echo $package['create_date']; ?></span> <?php _e('Create Date','wpdmpro'); ?></li>
            <li class="list-group-item"><span class="label label-info pull-right"><?php echo $package['update_date']; ?></span> <?php _e('Last Updated','wpdmpro'); ?></li>

            <li class="list-group-item">
            <div class="pull-right">
                <?php echo $package['download_link'];?>
            </div>
            <div class="clear"></div>
        </li>
        </ul>
         
		<?php echo wpautop(get_the_content()); ?>
		<?php
			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . __( 'Pages:', 'twentyfifteen' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . __( 'Page', 'twentyfifteen' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
		?>
	</div><!-- .entry-content -->

    <footer class="entry-footer w3eden">
        <div class="pull-left">
            <?php edit_post_link( __( 'Edit', 'twentyfifteen' ), '<span class="edit-link">', '</span>' ); ?>
        </div>
        <div class="pull-right">
            <?php echo $package['download_link'];?>
        </div>
        <div class="clear"></div>
    </footer>
    <!-- .entry-footer -->
	

</article><!-- #post-## -->
