<?php

if(!class_exists('SwiftFooterTop')){

    class SwiftFooterTop extends WP_Widget {

        function __construct() {
            parent::__construct(false, 'Footer Top');
        }

        function widget($args, $instance) {
            extract( $args );
            $title = apply_filters('widget_title', @$instance['title']);
            $txtcolor = isset($instance['txtcolor']) && $instance['txtcolor'] != ''?"style='color: {$instance['txtcolor']}'';":"";
            ?>

            <div class="email-box-wrap">
                <img style="width: 96px" src="<?php echo isset($instance['img']) && $instance['img'] != ''? $instance['img'] : get_stylesheet_directory_uri().'/assets/images/svg/email.svg'; ?>" alt="Email Box">
                <p class="email-box-text" <?php echo $txtcolor; ?>><?php echo isset($instance['headline'])?$instance['headline']:'Join our newsletter and get <strong>3 free products</strong>, instantly.'; ?></p>
                <div class="subscribe">
                    <form action="<?php echo isset($instance['service_url'])?$instance['service_url']:''; ?>" class="subscribe-form subscribe-form-2" id="subfrm">
                        <input type="email" class="form-control" placeholder="Enter your email to join">
                        <a href="#" class="subscribe-action" onclick="jQuery('#subfrm').submit();return false;"><i class="ion ion-android-arrow-forward"></i></a>
                        <small <?php echo $txtcolor; ?>><?php echo isset($instance['info'])?$instance['info']:'Plus nothing but quality pixels in your inbox every 2 weeks!'; ?></small>
                    </form>
                </div>
            </div>



            <?php
        }

        function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['img'] = strip_tags($new_instance['img']);
            $instance['headline'] = strip_tags($new_instance['headline']);
            $instance['info'] = strip_tags($new_instance['info']);
            $instance['service_url'] = strip_tags($new_instance['service_url']);
            $instance['txtcolor'] = strip_tags($new_instance['txtcolor']);
            return $instance;
        }

        function form($instance) {
            $headline = isset($instance['headline']) ? esc_attr($instance['headline']) : "";
            $img = isset($instance['img']) ? esc_attr($instance['img']) : "";
            $info = isset($instance['info']) ? esc_attr($instance['info']) : "";
            $service_url = isset($instance['service_url']) ? esc_attr($instance['service_url']) : "";
            $txtcolor = isset($instance['txtcolor']) ? esc_attr($instance['txtcolor']) : "";

            ?>

            <p>
                <label for="<?php echo $this->get_field_id('img'); ?>"><?php _e('Icon URL:'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('img'); ?>" name="<?php echo $this->get_field_name('img'); ?>" type="text" value="<?php echo $img; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('headline'); ?>"><?php _e('Headline:'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('headline'); ?>" name="<?php echo $this->get_field_name('headline'); ?>" type="text" value="<?php echo $headline; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('info'); ?>"><?php _e('Info:'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('info'); ?>" name="<?php echo $this->get_field_name('info'); ?>" type="text" value="<?php echo $info; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('service_url'); ?>"><?php _e('Service URL:'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('service_url'); ?>" name="<?php echo $this->get_field_name('service_url'); ?>" type="text" value="<?php echo $service_url; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('txtcolor'); ?>"><?php _e('Text Color:'); ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id('txtcolor'); ?>" name="<?php echo $this->get_field_name('txtcolor'); ?>" type="text" value="<?php echo $txtcolor; ?>" />
            </p>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    jQuery('.color-picker').wpColorPicker();
                });
            </script>
            <?php
        }
    }

    add_action('widgets_init', function(){
        register_widget("SwiftFooterTop");
    });
}
