<?php
if (!defined('ABSPATH')) die();
get_header();
the_post();
$package = \WPDM\Package::get(get_the_ID());
$movie = maybe_unserialize(get_post_meta(get_the_ID(), '__tmdb_movie', true));
if(!is_array($movie)) {

    ?>

    <!--=== page header ===-->
    <section class="page-header">
        <div class="container-fluid">
            <div class="page-header-content">
                <?php echo get_the_term_list(get_the_ID(), 'wpdmcategory', '<span class="prod-label">', " | ", "</span>"); ?>
                <div class="page-header-title"><?php the_title(); ?></div>
                <div class="page-header-tag"><?php echo get_post_meta(get_the_ID(), 'sub_title', true); ?></div>
                <ul class="list-inline product-info-btn">
                    <li class="list-inline-item"><a class="btn main-btn com-like-btn"
                                                    href="<?php echo comments_link(); ?>"><i
                                    class="ion ion-chatbox"></i><span><?php $count = get_comment_count($package['ID']);
                                echo $count['approved']; ?></span></a></li>

                    <li class="list-inline-item"><a class="btn main-btn com-like-btn" href="#"><i
                                    class="ion ion-eye"></i><span><?php echo number_format($package['view_count'], 0, "", ","); ?></span></a>
                    </li>
                    <li class="list-inline-item"><a class="btn main-btn nav-btn prev-cart-btn"
                                                    href="<?php echo get_post_meta($package['ID'], 'preview_url', true); ?>"><i
                                    class="ion ion-eye icon-hidden"></i><span>Preview</span></a></li>
                    <?php if ($package['effective_price'] > 0) { ?>
                        <li class="list-inline-item">
                            <button class="btn main-btn prev-cart-btn" data-toggle="modal" data-target="#downladLink">
                                <span>Add to Cart</span> <em><?php echo $package['price_range']; ?></em></button>
                        </li>
                    <?php } else { ?>
                        <li class="list-inline-item">
                            <button class="btn main-btn prev-cart-btn" data-toggle="modal" data-target="#downladLink">
                                <span>Download</span></button>
                        </li>
                    <?php } ?>
                </ul>
            </div>
        </div>
    </section>


    <!-- Modal -->
    <div class="modal fade" id="downladLink" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <!-- div class="modal-header">

                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true"><i class="ion-close-round" style="font-size: 13px"></i></span>
                    </button>
                </div -->
                <div class="modal-body">

                    <?php echo $package['download_link_extended']; ?>

                </div>

            </div>
        </div>
    </div>

    <!--=== products details ===-->
    <section class="ui-product-detail">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="post-author-info">
                        <a href="<?php echo $package['author_profile_url']; ?>"><?php echo $package['store_logo']; ?></a>
                        <span>Published by <strong><a
                                        href="<?php echo $package['author_profile_url']; ?>"><?php the_author(); ?></a></strong></span>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="single-product-item">
                        <?php wpdm_post_thumb(array(1400, 840), array('class' => 'img-fluid')); ?>

                    </div>
                </div>

            </div>
            <div class="product-detail-text">
                <div class="row">
                    <div class="col-lg-7 col-md-12 mx-auto">
                        <div class="row">
                            <div class="col-lg-12 col-md-10 col-sm-10 mx-auto">
                                <div class="product-detail-text-main">

                                    <?php echo $package['description']; ?>

                                </div>
                                <div class="single-product-feature">
                                    <strong>Item Info</strong>
                                    <ul class="list-unstyled">
                                        <li class=""><i
                                                    class="ion ion-checkmark"></i><span><?php echo $package['version'] ? $package['version'] : '1.0.0'; ?></span>
                                        </li>
                                        <li class=""><i
                                                    class="ion ion-checkmark"></i><span><?php echo $package['package_size']; ?></span>
                                        </li>
                                        <li class=""><i
                                                    class="ion ion-checkmark"></i><span><?php echo $package['view_count']; ?>
                                                views</span></li>
                                        <li class=""><i
                                                    class="ion ion-checkmark"></i><span><?php echo $package['download_count']; ?>
                                                downloads</span></li>
                                        <li class=""><i
                                                    class="ion ion-checkmark"></i><span><?php echo $package['file_count']; ?>
                                                files</span></li>
                                        <li class=""><i
                                                    class="ion ion-checkmark"></i><span>Last Update <?php echo $package['update_date']; ?></span>
                                        </li>
                                    </ul>
                                </div>

                                <div class="single-product-compat">
                                    <strong>File Types</strong><br/>
                                    <?php echo \WPDM\Package::fileTypes($package['ID'], true, 32); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if (comments_open()) { ?>
                <!--=== comments ===-->
                <div class="comment-posts">
                    <div class="row">
                        <div class="col-lg-7 col-md-12 mx-auto">

                            <div class="card mx_comments">
                                <div class="card-body">

                                    <?php comments_template(); ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </section>

    <!--=== products ===-->
    <section class="product">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-9 mx-auto">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="profile-wrap text-center">
                                <?php echo $package['store_logo']; ?>
                                <p class="email-box-text">More products from <strong><?php the_author(); ?></strong></p>

                            </div>
                        </div>

                        <?php
                        $packages = get_posts(array('post_type' => 'wpdmpro', 'author' => $post->post_author, 'posts_per_page' => 3, 'exclude' => array(get_the_ID())));
                        foreach ($packages as $apack) {
                            ?>

                            <div class="col-lg-4 col-md-4 col-sm-6">
                                <div class="product__item">
                                    <div class="card">
                                        <div class="product__item-img">
                                            <?php wpdm_thumb($apack->ID, array(350, 210), array('class' => 'card-img-top img-fluid product-face', 'crop' => true)); ?>
                                            <div class="product__item-overlay">
                                                <ul class="list-inline product-info">
                                                    <li class="list-inline-item"><a
                                                                href="<?php echo get_permalink($apack->ID); ?>"><i
                                                                    class="ion ion-ios-eye"></i></a>
                                                    </li>
                                                    <li class="list-inline-item"><a
                                                                href="<?php echo get_permalink($apack->ID); ?>"><i
                                                                    class="ion ion-ios-add"></i></a></li>
                                                </ul>

                                            </div>
                                        </div>
                                        <div class="product__content-inner card-body">
                                            <div class="product__title-price">
                                                <a href="<?php echo get_permalink($apack->ID); ?>"><h5
                                                            class="card-title"><?php echo $apack->post_title; ?></h5>
                                                </a>
                                                <div class="product-price">
                                                    <span><?php echo function_exists('wpdmpp_price_range') ? wpdmpp_price_range($apack->ID) : 'Free'; ?></span>
                                                </div>
                                            </div>
                                            <div class="product-admin"><a
                                                        href="<?php echo get_author_posts_url($apack->post_author); ?>">by <?php echo get_user_by('id', $apack->post_author)->display_name; ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php
                        }
                        ?>
                        <div class="col-lg-12">
                            <div class="profile-wrap text-center">
                                <a class="btn main-btn" href="<?php echo $package['author_profile_url']; ?>">View
                                    All</a>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <style>
        .page-header::before {
            background: url("<?php echo $package['preview'];  ?>") no-repeat scroll center center / cover;
        }
    </style>

    <?php

} else include "single-wpdmpro-movie.php";
    get_footer();
