<?php
/**
 * Template Name: Homepage ( Movies )
 * User: shahnuralam
 * Date: 4/15/18
 * Time: 9:10 PM
 */
if (!defined('ABSPATH')) die();

get_header();
_custom_background_cb();
?>


<!--=== Background video play ===-->
<section class="background-video-play swift-custom-background">
    <div class="bg-video">

    </div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="intro-content-wrap d-flex align-items-center">
                    <div class="intro-content text-center">
                        <?php dynamic_sidebar("homepage_top"); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!--=== products ===-->
<section class="product">
    <div class="container-fluid">
        <div class="tab-pane product-tab">
            <ul class="nav nav-tabs justify-content-center" id="nav-tab" role="tablist">
                <li><a class="nav-item nav-link active" id="nav-home-tab" data-toggle="tab" href="#nav-home"
                       role="tab" aria-controls="nav-home" aria-selected="true"><?php _e('Featured','swift'); ?></a></li>
                <li><a class="nav-item nav-link" id="nav-profile-tab" data-toggle="tab" href="#nav-profile"
                       role="tab" aria-controls="nav-profile" aria-selected="false"><?php _e('New Release','swift'); ?></a></li>
                <li><a class="nav-item nav-link" id="nav-contact-tab" data-toggle="tab" href="#nav-contact"
                       role="tab" aria-controls="nav-contact" aria-selected="false"><?php _e('Popular','swift'); ?></a></li>
            </ul>
        </div>
        <div class="tab-content" id="nav-tabContent close">
            <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
                <div class="row">
                    <?php
                    $packages = get_posts(array('post_type' => 'wpdmpro', 'posts_per_page' => 12, 'tag' => 'featured', 'orderby' => 'rand' ));
                    foreach ($packages as $package){
                    ?>
                    <div class="col-lg-3 col-md-6 col-sm-6">
                        <div class="product__item">
                            <div class="card">
                                <div class="product__item-img">
                                    <?php wpdm_thumb($package->ID, array(420, 640), array('class' => 'card-img-top img-fluid product-face', 'crop' => true)); ?>
                                    <div class="product__item-overlay">
                                        <ul class="list-inline product-info">
                                            <li class="list-inline-item"><a href="<?php echo get_permalink($package->ID); ?>"><i class="ion ion-ios-play-circle"></i></a></li>
                                        </ul>
                                        <div class="product-action"><a href="#"><i class="ion ion-ios-eye"></i></a><strong><?php echo get_post_meta($package->ID, '__wpdm_view_count', true); ?></strong></div>
                                    </div>
                                </div>
                                <div class="product__content-inner card-body">
                                    <div class="product__title-price">
                                        <a href="<?php echo get_permalink($package->ID); ?>"><h5 class="card-title"><?php echo $package->post_title; ?></h5></a>

                                    </div>
                                    <div class="product-admin"><a href="#">Released On <?php
                                            $moviedata = get_post_meta($package->ID, '__tmdb_movie', true);
                                            echo date(get_option('date_format'), strtotime($moviedata['release_date']));
                                            ?></a></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php } ?>


                </div>
            </div>
            <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                <div class="row">
                    <?php
                    $packages = get_posts(array('post_type' => 'wpdmpro', 'posts_per_page' => 12, 'orderby' => 'meta_value_num', 'meta_key' => '__wpdm_tmdb_year', 'order' => 'desc'));
                    foreach ($packages as $package){
                        ?>
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="product__item">
                                <div class="card">
                                    <div class="product__item-img">
                                        <?php wpdm_thumb($package->ID, array(420, 640), array('class' => 'card-img-top img-fluid product-face', 'crop' => true)); ?>
                                        <div class="product__item-overlay">
                                            <ul class="list-inline product-info">
                                                <li class="list-inline-item"><a href="<?php echo get_permalink($package->ID); ?>"><i class="ion ion-ios-play-circle"></i></a></li>
                                            </ul>
                                            <div class="product-action"><a href="#"><i class="ion ion-ios-eye"></i></a><strong><?php echo get_post_meta($package->ID, '__wpdm_view_count', true); ?></strong></div>
                                        </div>
                                    </div>
                                    <div class="product__content-inner card-body">
                                        <div class="product__title-price">
                                            <a href="<?php echo get_permalink($package->ID); ?>"><h5 class="card-title"><?php echo $package->post_title; ?></h5></a>
                                        </div>
                                        <div class="product-admin"><a href="#">Released On <?php
                                                $moviedata = get_post_meta($package->ID, '__tmdb_movie', true);
                                                echo date(get_option('date_format'), strtotime($moviedata['release_date']));
                                                ?></a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>


                </div>
            </div>
            <div class="tab-pane fade" id="nav-contact" role="tabpanel" aria-labelledby="nav-contact-tab">
                <div class="row">
                    <?php
                    $packages = get_posts(array('post_type' => 'wpdmpro', 'posts_per_page' => 12, 'orderby' => 'meta_value_num', 'meta_key' => '__wpdm_view_count', 'order' => 'desc'));
                    foreach ($packages as $package){
                        ?>
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="product__item">
                                <div class="card">
                                    <div class="product__item-img">
                                        <?php wpdm_thumb($package->ID, array(420, 640), array('class' => 'card-img-top img-fluid product-face', 'crop' => true)); ?>
                                        <div class="product__item-overlay">
                                            <ul class="list-inline product-info">
                                                <li class="list-inline-item"><a href="<?php echo get_permalink($package->ID); ?>"><i class="ion ion-ios-play-circle"></i></a></li>
                                            </ul>
                                            <div class="product-action"><a href="#"><i class="ion ion-ios-eye"></i></a><strong><?php echo get_post_meta($package->ID, '__wpdm_view_count', true); ?></strong></div>
                                        </div>
                                    </div>
                                    <div class="product__content-inner card-body">
                                        <div class="product__title-price">
                                            <a href="<?php echo get_permalink($package->ID); ?>"><h5 class="card-title"><?php echo $package->post_title; ?></h5></a>

                                        </div>
                                        <div class="product-admin"><a href="#">Released On <?php
                                                $moviedata = get_post_meta($package->ID, '__tmdb_movie', true);
                                                echo date(get_option('date_format'), strtotime($moviedata['release_date']));
                                                ?></a></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <!-- div class="col-12 mt-5">
                        <div class="text-center"><button type="submit" class="btn btn-primary main-btn">Reload More</button></div>
                    </div -->
                </div>
            </div>
        </div>
    </div>
</section>


<?php get_footer();