<?php
/**
 * User: shahnuralam
 * Date: 4/15/18
 * Time: 11:03 AM
 */


include "widgets/class.HomepageTop.php";
include "widgets/class.FooterTop.php";
include "libs/update-checker.php";
define('SWIFT_ID', 74639);
class Swift{

    var $themeID = 74639;

    function __construct()
    {
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ), 999999 );
        add_action( 'widgets_init', array($this, 'registerSidebar') );
        add_action( 'wp_head', array($this, 'customBackgroundCSS') );

        $check_update = new SwiftThemeUpdateChecker(
            'swift',
            'https://www.wpdownloadmanager.com/theme-updates/swift.json'
        );
    }

    function enqueueScripts(){


        wp_register_style( 'swift-ionicons', 'https://unpkg.com/ionicons@4.2.0/dist/css/ionicons.min.css' );
        wp_enqueue_style('swift-ionicons');

        wp_enqueue_style( 'swift-main', get_stylesheet_uri() , array('bootstrap'));

        wp_register_style( 'swift-app', get_stylesheet_directory_uri() . '/assets/css/app-dark.css' );
        wp_enqueue_style('swift-app', array('bootstrap'));

        wp_register_style( 'swift-responsive', get_stylesheet_directory_uri() . '/assets/css/responsive.css' );
        wp_enqueue_style('swift-responsive', array('bootstrap'));

        wp_register_script( 'swift-popper', get_stylesheet_directory_uri() . '/assets/js/popper.js' );
        wp_enqueue_script('swift-popper');

        wp_register_script( 'swift-app', get_stylesheet_directory_uri() . '/assets/js/app.js' );
        wp_enqueue_script('swift-app');

        //wp_deregister_style('attire-responsive');
    }

    function registerSidebar(){
        register_sidebar( array(
            'name' => __( 'Homepage Top', 'swift' ),
            'id' => 'homepage_top',
            'description' => __( 'Homepage Top', 'swift' ),
            'before_widget' => '<div class="homepage-top-widget">',
            'after_widget'  => '</div>',
            'before_title'  => '',
            'after_title'   => '',
        ) );
        register_sidebar( array(
            'name' => __( 'Footer Top', 'swift' ),
            'id' => 'footer_top',
            'description' => __( 'Footer Top', 'swift' ),
            'before_widget' => '<div class="footer-top-widget">',
            'after_widget'  => '</div>',
            'before_title'  => '',
            'after_title'   => '',
        ) );
    }

    function customBackgroundCSS() {
        // $background is the saved custom image, or the default image.
        $background = set_url_scheme( get_background_image() );

        // $color is the saved custom color.
        // A default has to be specified in style.css. It will not be printed here.
        $color = get_background_color();

        if ( $color === get_theme_support( 'custom-background', 'default-color' ) ) {
            $color = false;
        }

        if ( ! $background && ! $color ) {
            if ( is_customize_preview() ) {
                echo '<style type="text/css" id="custom-background-css"></style>';
            }
            return;
        }

        $style = $color ? "background-color: #$color;" : '';

        if ( $background ) {
            $image = ' background-image: url("' . esc_url_raw( $background ) . '");';

            // Background Position.
            $position_x = get_theme_mod( 'background_position_x', get_theme_support( 'custom-background', 'default-position-x' ) );
            $position_y = get_theme_mod( 'background_position_y', get_theme_support( 'custom-background', 'default-position-y' ) );

            if ( ! in_array( $position_x, array( 'left', 'center', 'right' ), true ) ) {
                $position_x = 'left';
            }

            if ( ! in_array( $position_y, array( 'top', 'center', 'bottom' ), true ) ) {
                $position_y = 'top';
            }

            $position = " background-position: $position_x $position_y;";

            // Background Size.
            $size = get_theme_mod( 'background_size', get_theme_support( 'custom-background', 'default-size' ) );

            if ( ! in_array( $size, array( 'auto', 'contain', 'cover' ), true ) ) {
                $size = 'auto';
            }

            $size = " background-size: $size;";

            // Background Repeat.
            $repeat = get_theme_mod( 'background_repeat', get_theme_support( 'custom-background', 'default-repeat' ) );

            if ( ! in_array( $repeat, array( 'repeat-x', 'repeat-y', 'repeat', 'no-repeat' ), true ) ) {
                $repeat = 'repeat';
            }

            $repeat = " background-repeat: $repeat;";

            // Background Scroll.
            $attachment = get_theme_mod( 'background_attachment', get_theme_support( 'custom-background', 'default-attachment' ) );

            if ( 'fixed' !== $attachment ) {
                $attachment = 'scroll';
            }

            $attachment = " background-attachment: $attachment;";

            $style .= $image . $position . $size . $repeat . $attachment;
        }
        ?>
        <style type="text/css" id="swift-background-css">
            .swift-custom-background { <?php echo trim( $style ); ?> }
        </style>
        <?php
    }
}

new Swift();