<?php

if(!class_exists('SwiftHomepageTop')){

    class SwiftHomepageTop extends WP_Widget {

        function __construct() {
            parent::__construct(false, 'Homepage Top');
        }

        function widget($args, $instance) {
            extract( $args );
            $title = apply_filters('widget_title', @$instance['title']);
            $txtcolor = isset($instance['txtcolor']) && $instance['txtcolor'] != ''?"style='color: {$instance['txtcolor']}'';":"";

            ?>


                    <div class="intro-main-title" <?php echo $txtcolor; ?>><?php echo $title; ?></div>
                    <div class="intro-tag" <?php echo $txtcolor; ?>><?php echo isset($instance['intro'])?$instance['intro']:''; ?></div>
                    <div><a href="<?php echo isset($instance['btn_url'])?$instance['btn_url']:''; ?>" class="btn main-btn"><?php echo isset($instance['btn_label'])?$instance['btn_label']:''; ?></a></div>


            <?php
        }

        function update($new_instance, $old_instance) {
            $instance = $old_instance;
            $instance['title'] = strip_tags($new_instance['title']);
            $instance['intro'] = strip_tags($new_instance['intro']);
            $instance['btn_label'] = strip_tags($new_instance['btn_label']);
            $instance['btn_url'] = strip_tags($new_instance['btn_url']);
            $instance['txtcolor'] = strip_tags($new_instance['txtcolor']);
            return $instance;
        }

        function form($instance) {
            $title = isset($instance['title']) ? esc_attr($instance['title']) : "";
            $intro = isset($instance['intro']) ? esc_attr($instance['intro']) : "";
            $btn_label = isset($instance['btn_label']) ? esc_attr($instance['btn_label']) : "";
            $btn_url = isset($instance['btn_url']) ? esc_attr($instance['btn_url']) : "";
            $txtcolor = isset($instance['txtcolor']) ? esc_attr($instance['txtcolor']) : "";
            ?>

            <p>
                <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('intro'); ?>"><?php _e('Intro:'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('intro'); ?>" name="<?php echo $this->get_field_name('intro'); ?>" type="text" value="<?php echo $intro; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('btn_label'); ?>"><?php _e('Button Label:'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('btn_label'); ?>" name="<?php echo $this->get_field_name('btn_label'); ?>" type="text" value="<?php echo $btn_label; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('btn_url'); ?>"><?php _e('Button URL:'); ?></label>
                <input class="widefat" id="<?php echo $this->get_field_id('btn_url'); ?>" name="<?php echo $this->get_field_name('btn_url'); ?>" type="text" value="<?php echo $btn_url; ?>" />
            </p>
            <p>
                <label for="<?php echo $this->get_field_id('txtcolor'); ?>"><?php _e('Text Color:'); ?></label>
                <input class="widefat color-picker" id="<?php echo $this->get_field_id('txtcolor'); ?>" name="<?php echo $this->get_field_name('txtcolor'); ?>" type="text" value="<?php echo $txtcolor; ?>" />
            </p>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    jQuery('.color-picker').wpColorPicker();
                });
            </script>
            <?php
        }
    }

    add_action('widgets_init', function(){
        register_widget("SwiftHomepageTop");
    });
}
