<?php
/**
 * User: shahnuralam
 * Date: 4/15/18
 * Time: 9:10 PM
 */
if (!defined('ABSPATH')) die();

get_header();

?>

    <!--=== products ===-->
    <section class="product product-category">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="category-tools">
                        <div class="category-title">
                            <div class="media">
                                <div class="pull-left">
                                    <?php $icon = \WPDM\libs\CategoryHandler::icon(get_queried_object()->term_id); if($icon !='') { ?>
                                        <img style="width: 96px;border-radius: 500px" src="<?php echo $icon; ?>" alt="<?php echo single_term_title(); ?>" />
                                    <?php } ?>
                                </div>
                                <div class="media-body" style="padding: 15px;">
                                    <h3><?php echo single_term_title(); ?></h3>
                                    <p><?php echo term_description() ?></p>
                                </div>
                            </div>
                        </div>
                        <!-- div class="selection-option">
                            <div class="select" tabindex="1">
                                <input class="selectopt" name="test" type="radio" id="opt1" checked>
                                <label for="opt1" class="option">Newest</label>
                                <input class="selectopt" name="test" type="radio" id="opt2">
                                <label for="opt2" class="option">Popupar</label>
                                <input class="selectopt" name="test" type="radio" id="opt3">
                                <label for="opt3" class="option">Updated</label>

                            </div>
                        </div-->
                    </div>
                </div>
            </div>
            <div class="row">
                <?php while (have_posts()){ the_post();
                    $movie = maybe_unserialize(get_post_meta(get_the_ID(), '__tmdb_movie', true));
                    $thumb_size = is_array($movie)?array(420, 640):array(350, 210);
                ?>
                    <div class="col-lg-3 col-md-6 col-sm-6">
                        <div class="product__item">
                            <div class="card">
                                <div class="product__item-img">
                                    <?php wpdm_thumb(get_the_ID(), $thumb_size, array('class' => 'card-img-top img-fluid product-face', 'crop' => true)); ?>
                                    <div class="product__item-overlay">
                                        <ul class="list-inline product-info">
                                            <li class="list-inline-item"><a href="<?php the_permalink(); ?>"><i class="ion ion-ios-add"></i></a></li>
                                        </ul>
                                        <div class="product-action"><a href="<?php the_permalink(); ?>"><i class="ion ion-ios-eye"></i></a><strong><?php echo get_post_meta(get_the_ID(),'__wpdm_view_count', true); ?></strong></div>
                                    </div>
                                </div>
                                <div class="product__content-inner card-body">
                                    <div class="product__title-price">
                                        <a href="<?php the_permalink(); ?>"><h5 class="card-title"><?php the_title(); ?></h5></a>
                                        <?php if(!is_array($movie)){ ?>
                                        <div class="product-price"><span><?php echo function_exists('wpdmpp_price_range')? wpdmpp_price_range(get_the_ID()):'Free'; ?></span></div>
                                        <?php } ?>
                                    </div>
                                    <?php if(!is_array($movie)){ ?>
                                    <div class="product-admin"><a href="<?php echo get_author_posts_url($post->post_author); ?>">by <?php the_author(); ?></a></div>
                                    <?php } else { ?>
                                        <div class="product-admin"><a href="#">Released On <?php
                                                echo date(get_option('date_format'), strtotime($movie['release_date']));
                                                ?></a></div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <div class="col-12 mt-5">
                    <div class="text-center">
                        <?php
                        global $wp_query;
                        if (  $wp_query->max_num_pages > 1 ) : ?>
                            <div class="clear"></div>
                            <div id="nav-below" class="navigation post box arc">
                                <?php get_template_part('pagination'); ?>
                            </div><!-- #nav-below -->
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>



<?php
get_footer();