<?php
if (!defined('ABSPATH')) die();
//wpdmprecho($movie);
$backdrop = get_post_meta(get_the_ID(), '__tmdb_backdrop', true);
if(!$backdrop)
    $backdrop = "https://image.tmdb.org/t/p/w1280{$movie['backdrop_path']}";
?>

    <!--=== page header ===-->
    <section class="page-header" style="background: url('<?php echo $backdrop; ?>');background-size: cover">
        <div class="container-fluid">
            <div class="page-header-content">

                <div class="media">
                    <div class="pull-left">

                        <?php the_post_thumbnail('medium', array('class' => 'movie-poster')); ?>

                    </div>
                    <div class="media-body">
<br/>
                        <?php echo get_the_term_list(get_the_ID(), 'wpdmcategory', '<span class="prod-label">', " | ", "</span>"); ?>
                        <div class="page-header-title"><?php the_title(); ?></div>
                        <div class="page-header-tag"><?php echo $movie['tagline']; ?></div>
                        <div class="page-header-tag">Genre: <?php echo $movie['genres'][0]['name']; ?></div>
                        <div class="page-header-tag">Popularity: <?php echo number_format($movie['popularity'],2 ); ?></div>
                        <div class="page-header-tag">Release Date: <?php echo date(get_option('date_format'), strtotime($movie['release_date'])); ?></div>
                        <div class="page-header-tag">
                            <hr style="margin: 30px 0 20px 0"/>
                            <a target="_blank" href="https://www.imdb.com/title/<?php echo $movie['imdb_id']; ?>/"><img alt="IMDB" src="https://cdn4.iconfinder.com/data/icons/socialmediaicons_v120/48/imdb.png" style="width: 32px"></a>&nbsp;
                            <a href="<?php echo isset($package['tmdb_torrent'])?$package['tmdb_torrent']:'#'; ?>"><img alt="Torrent" src="https://cdn2.iconfinder.com/data/icons/metro-ui-icon-set/512/uTorrent.png" style="width: 32px;border-radius: 3px" /></a>&nbsp;
                            <a href="#comments"><img alt="Torrent" src="https://cdn2.iconfinder.com/data/icons/arrows-and-universal-actions-icon-set/256/plus_circle-512.png" style="width: 32px;border-radius: 3px;background: #03A6FF;padding: 5px" /></a>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

 

    <!--=== products details ===-->
    <section class="ui-product-detail">
        <div class="container-fluid">
            <div class="row">

                <div class="col-lg-12">
                    <div class="single-product-item">
                         <?php if(isset($package['tmdb_trailer']) && $package['tmdb_trailer'] != ''){ ?>
                             <iframe style="border-radius: 6px;overflow: hidden;max-width: 100%" width="1400" height="900" src="https://www.youtube.com/embed/<?php echo $package['tmdb_trailer']; ?>" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
                         <?php } ?>
                    </div>
                </div>

            </div>
            <div class="product-detail-text">
                <div class="row">
                    <div class="col-lg-7 col-md-12 mx-auto">
                        <div class="row">
                            <div class="col-lg-12 col-md-10 col-sm-10 mx-auto">
                                <?php echo $movie['overview']; // wpdmprecho($movie); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="product-detail-text">
                <div class="row">
                    <div class="col-lg-7 col-md-12 mx-auto">
                        <div class="row">
                            <div class="col-lg-12 col-md-10 col-sm-10 mx-auto">
                                <h3>Casts</h3>

                                <table class="table table-casts">
                                    <thead>
                                        <tr>
                                            <td></td>
                                            <td><strong>Name</strong></td>
                                            <td><strong>Char</strong></td>
                                        </tr>
                                    </thead>
                                <?php
                                $upload_dir = wp_upload_dir();

                                $upload_url = $upload_dir['baseurl'].'/wpdm-tmdb/casts/';
                                $upload_dir = $upload_dir['basedir'].'/wpdm-tmdb/casts/';
                                if(!file_exists($upload_dir)) mkdir($upload_dir, 0755, 1);
                                foreach($movie['credits']['cast'] as $char){  if($char['profile_path'] != '') {
                                    $filename = sanitize_file_name($char['name']).'.jpg';
                                    $fileurl = $upload_url . $filename;
                                    //wpdmdd($upload_dir.$filename);
                                    if(!file_exists($upload_dir.$filename)) {
                                        $filepath = \WPDM\libs\FileSystem::copyURL("https://image.tmdb.org/t/p/w1280" . $char['profile_path'], $filename, false);
                                        rename($filepath, $upload_dir . $filename);
                                    }
                                    ?>
                                    <tr>
                                        <td>
                                            <img style="width: 32px;border-radius: 3px" src="<?php echo $fileurl; ?>" />
                                        </td>
                                        <td><?php echo $char['name'];  ?></td>
                                        <td><?php echo $char['character']; ?></td>
                                    </tr>
                                <?php }} ?>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php if(comments_open()){ ?>
            <!--=== comments ===-->
            <div class="comment-posts">
                <div class="row">
                    <div class="col-lg-7 col-md-12 mx-auto">

                            <div class="card mx_comments">
                                <div class="card-body">

                                    <?php comments_template(); ?>
                                </div>
                            </div>

                    </div>
                </div>
            </div>
            <?php } ?>
        </div>
    </section>
    
    <!--=== products ===-->
    <section class="product">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-9 mx-auto">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="profile-wrap text-center">

                                <img src="https://cdn2.iconfinder.com/data/icons/circle-icons-1/64/filmreel-512.png" alt="Similar Movies" />
                                <p class="email-box-text">Similar Movies You May Like</p>

                            </div>
                        </div>

                        <?php
                        $packages = get_posts(array('post_type' => 'wpdmpro', 'orderby' => 'rand', 'posts_per_page' => 3, 'exclude' => array( get_the_ID() )));
                        foreach ($packages as $apack) {
                            ?>

                            <div class="col-lg-4 col-md-4 col-sm-6">
                                <div class="product__item">
                                    <div class="card">
                                        <div class="product__item-img">
                                            <?php wpdm_thumb($apack->ID, array(420, 640), array('class' => 'card-img-top img-fluid product-face')); ?>
                                            <div class="product__item-overlay">
                                                <ul class="list-inline product-info">
                                                    <li class="list-inline-item"><a href="<?php echo get_permalink($apack->ID); ?>"><i class="ion ion-ios-play-circle"></i></a>
                                                    </li>

                                                </ul>
                                                <div class="product-action"><a href="#"><i
                                                                class="ion ion-ios-eye"></i></a><strong><?php echo get_post_meta($apack->ID, '__wpdm_view_count', true); ?></strong></div>
                                            </div>
                                        </div>
                                        <div class="product__content-inner card-body">
                                            <div class="product__title-price">
                                                <a href="<?php echo get_permalink($apack->ID); ?>"><h5 class="card-title"><?php echo $apack->post_title; ?></h5>
                                                </a>

                                            </div>
                                            <div class="product-admin"><?php echo strip_tags($apack->post_excerpt); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <?php
                        }
                            ?>
                        <div class="col-lg-12">
                            <div class="profile-wrap text-center">
                                <a class="btn main-btn" href="<?php echo $package['author_profile_url']; ?>">View All</a>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

