<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages and that
 * other 'pages' on your WordPress site will use a different template.
 */

get_header();
the_post();
?>

<!--=== page header ===-->
<section class="page-header single-post-title">
    <div class="container-fluid">
        <div class="page-header-content">
            <div class="page-header-title"><?php the_title(); ?></div>
            <div class="page-header-tag"><?php echo get_post_meta(get_the_ID(), 'sub_title', true); ?></div>
        </div>
    </div>
</section>

<!--=== products details ===-->
<section class="ui-product-detail single-post-detail">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-10 col-md-11 col-sm-11 mx-auto">
                <div class="single-product-item">
                    <?php wpdm_post_thumb(array(1200, 800), array('class' => 'img-fluid')); ?>
                </div>
            </div>
        </div>
        <div class="product-detail-text">
            <div class="row">
                <div class="col-lg-8 col-md-10 col-sm-10 mx-auto">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="product-detail-text-main">
                                <?php the_content(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php if(comments_open()){ ?>
        <!--=== comments ===-->
        <div class="comment-posts">
            <div class="row">
                <div class="col-lg-8 col-md-10 col-sm-10 mx-auto">
                        <div class="card mx_comments">
                            <div class="card-body">

                                <?php comments_template(); ?>
                            </div>
                        </div>
                </div>
            </div>
        </div>
        <?php } ?>
    </div>
</section>
<?php
get_footer();

