<?php
if (!defined('ABSPATH')) {
    exit;
}

do_action(ATTIRE_THEME_PREFIX . "body_content_after");

$canshow = AttireThemeEngine::NextGetOption('attire_back_to_top_visibility', 'show');
$canshow = $canshow === 'show' ? ' canshow' : '';
?>

<!--=== email box ===-->
<section class="email-box d-flex align-items-center swift-custom-background">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <?php dynamic_sidebar("footer_top"); ?>
            </div>
        </div>
    </div>
</section>

<!--=== footer area ===-->
<footer class="footer-area">
    <div class="container-fluid">
        <a href="#" class="back-to-top <?php echo esc_attr($canshow); ?>" rel="nofollow">
            <i class="fa fa-angle-up"></i>
        </a>
        <?php
        $num_widget = (int)AttireThemeEngine::NextGetOption('footer_widget_number', '3');
        if ($num_widget !== 0) {
            do_action(ATTIRE_THEME_PREFIX . "before_footer_widget_area");
            ?>
            <div class="footer-widgets-area-swift">
                <div class="<?php echo esc_attr(AttireThemeEngine::NextGetOption('footer_widget_content_layout_type', 'container')); ?> footer-widgets-outer">
                    <div class="row footer-widgets">
                        <?php
                        $col = 12 / $num_widget;
                        for ($i = 1; $i <= (int)$num_widget; $i++) {
                            echo '<div class="col-lg">';
                            dynamic_sidebar("footer" . $i);
                            echo '</div>';
                            if ($i < (int)$num_widget) {
                                do_action(ATTIRE_THEME_PREFIX . "between_footer_widgets");
                            }
                        }
                        ?>
                    </div>
                </div>
            </div>
            <?php
            do_action(ATTIRE_THEME_PREFIX . "after_footer_widget_area");
        }
        do_action(ATTIRE_THEME_PREFIX . "before_footer");

        ?>



        <hr>
        <div class="row">
            <?php if(get_option('__wpdm_author_dashboard') > 0){ ?>
            <div class="col-lg-3 col-md-4 col-sm-6">
                <div class="quick-action">
                    <ul class="list-inline">
                        <li class="list-inline-item"><a href="<?php echo get_permalink(get_option('__wpdm_author_dashboard')) ?>" class="btn main-btn"><?php echo get_the_title(get_option('__wpdm_author_dashboard')); ?></a><small><?php echo get_post_meta(get_option('__wpdm_author_dashboard'), 'sub_title', true); ?></small></li>
                    </ul>
                </div>
            </div>
            <?php } ?>
            <?php if(get_option('__wpdm_user_dashboard') > 0){ ?>
                <div class="col-lg-3 col-md-4 col-sm-6">
                    <div class="quick-action">
                        <ul class="list-inline">
                            <li class="list-inline-item"><a href="<?php echo get_permalink(get_option('__wpdm_user_dashboard')) ?>" class="btn main-btn nav-btn"><?php echo get_the_title(get_option('__wpdm_user_dashboard')); ?></a><small><?php echo get_post_meta(get_option('__wpdm_user_dashboard'), 'sub_title', true); ?></small></li>
                        </ul>
                    </div>
                </div>
            <?php } ?>

            <div class="col-lg-6 col-md-4 col-sm-6">
                <div class="quick-info">
                    <ul class="list-inline">
                        <li class="list-inline-item"><strong><?php $result = count_users(); echo $result['total_users']; ?></strong><small>Members</small></li>
                        <li class="list-inline-item"><strong><?php echo wp_count_posts('wpdmpro')->publish; ?></strong><small>Products</small></li>
                        <li class="list-inline-item"><strong><?php echo wpdm_total_downloads(); ?></strong><small>Downloads</small></li>
                    </ul>
                </div>
            </div>
        </div>
        <hr>

        <?php AttireThemeEngine::FooterStyle(); ?>
    </div>
</footer>

<?php wp_footer(); ?>
<script src="<?php echo get_stylesheet_directory_uri(); ?>/assets/js/app.js"></script>

</body>
</html>

