<?php
/**
 * Login and Signup form Template. Applied during cart checkout if user is not logged in and guest checkout disabled.
 *
 * This template can be overridden by copying it to yourtheme/download-manager/checkout-cart/checkout-login-register.php.
 *
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $sap, $current_user;
?>
<div id="checkout-login">
    <h3><?php _e('Please register or login to checkout','wpdm-prepmium-packages'); ?></h3>
    <div style="<?php if ($current_user->ID) echo "display:none"; else echo ""; ?>" id="csl">
        <div class="row">
            <div class="col-md-6">
                <div id='wpdmreg'>
                    <?php
                    $loginurl = get_option('__wpdm_login_url');
                    if($loginurl > 0)
                        $loginurl = get_permalink($loginurl);
                    else
                        $loginurl = wp_login_url();
                    $reg_redirect =  $_SERVER['REQUEST_URI'];
                    if(isset($params['redirect'])) $reg_redirect = esc_url($params['redirect']);
                    if(isset($_GET['redirect_to'])) $reg_redirect = esc_url($_GET['redirect_to']);
                    $force = uniqid();

                    $up = parse_url($reg_redirect);
                    if(isset($up['host']) && $up['host'] != $_SERVER['SERVER_NAME']) $reg_redirect = home_url('/');

                    $reg_redirect = esc_url($reg_redirect);
                    ?>

                    <form method="post" action="" id="registerform" name="registerform" class="login-form">

                        <input type="hidden" name="phash" value="<?php echo \WPDM\libs\Crypt::Encrypt(array('captcha' => 'false', 'autologin' => 'true', )); ?>" />
                        <input type="hidden" name="permalink" value="<?php echo wpdmpp_cart_page(); ?>" />

                        <?php global $wp_query; if(isset($_SESSION['reg_error'])&&$_SESSION['reg_error']!='') {  ?>
                                    <div class="error alert alert-danger">
                                        <b><?php _e('Registration Failed!','wpdm-premium-packages'); ?></b><br/>
                                        <?php echo $_SESSION['reg_error']; $_SESSION['reg_error']=''; ?>
                                    </div>
                                <?php } ?>

                                <div class="form-group">
                                    <div class="input-group input-group-lg">
                                        <span class="input-group-addon" ><i class="fa fa-male"></i></span>
                                        <input class="form-control input-lg" required="required" placeholder="<?php _e('Full Name','wpdm-premium-packages'); ?>" type="text" size="20" id="displayname" value="<?php echo isset($_SESSION['tmp_reg_info']['display_name'])?$_SESSION['tmp_reg_info']['display_name']:''; ?>" name="wpdm_reg[display_name]">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="input-group input-group-lg">
                                        <span class="input-group-addon" ><i class="fa fa-user"></i></span>
                                        <input class="form-control" required="required" placeholder="<?php _e('Username','wpdm-premium-packages'); ?>" type="text" size="20" class="required" id="user_login" value="<?php echo isset($_SESSION['tmp_reg_info']['user_login'])?$_SESSION['tmp_reg_info']['user_login']:''; ?>" name="wpdm_reg[user_login]">
                                    </div>
                                </div>
                                <div class="form-group">

                                    <div class="input-group input-group-lg">
                                        <span class="input-group-addon" ><i class="fa fa-envelope"></i></span>
                                        <input class="form-control input-lg" required="required" type="email" size="25" placeholder="<?php _e('E-mail','wpdm-premium-packages'); ?>" id="user_email" value="<?php echo isset($_SESSION['tmp_reg_info']['user_email'])?$_SESSION['tmp_reg_info']['user_email']:''; ?>" name="wpdm_reg[user_email]">
                                    </div>

                                </div>

                                    <div class="form-group row">
                                        <div class="col-md-6">
                                            <div class="input-group input-group-lg">
                                                <span class="input-group-addon" ><i class="fa fa-key"></i></span>
                                                <input class="form-control" placeholder="<?php _e('Password','wpdm-premium-packages'); ?>" title="<?php _e('Password','wpdm-premium-packages'); ?>" required="required" type="password" size="20" class="required" id="password" value="" name="wpdm_reg[user_pass]">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="input-group input-group-lg">
                                                <span class="input-group-addon" ><i class="fa fa-check-circle"></i></span>
                                                <input class="form-control input-lg" data-match="#password" data-match-error="<?php _e('Not Matched!','wpdm-premium-packages'); ?>" required="required" placeholder="<?php _e('Confirm Password','wpdm-premium-packages'); ?>" title="<?php _e('Confirm Password','wpdm-premium-packages'); ?>" type="password" size="20" class="required" equalto="#password" id="confirm_user_pass" value="" name="confirm_user_pass">
                                            </div>
                                        </div>
                                    </div>

                                <?php do_action("wpdm_register_form"); ?>
                                <?php do_action("register_form"); ?>


                                <div class="row">
                                    <div class="col-md-12"><button type="submit" class="btn btn-success btn-lg btn-block" id="registerform-submit" name="wp-submit"><i class="fa fa-user-plus"></i> &nbsp; <?php _e('Register','wpdm-premium-packages'); ?></button></div>

                                </div>

                            </form>

                    </div>
                </div>

                <div class="col-md-6">
                    <div id="wpdmlogin">
                    <?php do_action("wpdm_before_login_form"); ?>
                    <form name="loginform" id="loginform" action="" method="post" class="login-form" >
                        <input type="hidden" name="permalink" value="<?php the_permalink(); ?>" />

                        <?php global $wp_query; if(isset($_SESSION['login_error'])&&$_SESSION['login_error']!='') {  ?>
                            <div class="error alert alert-danger" >
                                <b><?php _e('Login Failed!','wpdm-premium-packages'); ?></b><br/>
                                <?php echo preg_replace("/<a.*?<\/a>\?/i","",$_SESSION['login_error']); $_SESSION['login_error']=''; ?>
                            </div>
                        <?php } ?>

                        <div class="form-group">
                            <div class="input-group input-group-lg">
                                <span class="input-group-addon" id="sizing-addon1"><i class="fa fa-user"></i></span>
                                <input placeholder="<?php _e('Username','wpdm-premium-packages'); ?>" type="text" name="wpdm_login[log]" id="user_login" class="form-control input-lg required text" value="" size="20" tabindex="38" />
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="input-group input-group-lg">
                                <span class="input-group-addon" id="sizing-addon1"><i class="fa fa-key"></i></span>
                                <input type="password" placeholder="<?php _e('Password','wpdm-premium-packages'); ?>" name="wpdm_login[pwd]" id="user_pass" class="form-control input-lg required password" value="" size="20" tabindex="39" />
                            </div>
                        </div>

                        <?php do_action("wpdm_login_form"); ?>
                        <?php do_action("login_form"); ?>

                        <div class="row" style="margin-bottom: 10px">
                            <div class="col-md-12"><label class="eden-checkbox"><input name="rememberme" type="checkbox" id="rememberme" value="forever" /><span><i class="fa fa-check"></i></span> <?php _e('Remember Me','wpdm-premium-packages'); ?></label></div>
                        </div>
                        <div class="row">
                            <div class="col-md-12"><button type="submit" name="wp-submit" id="loginform-submit" class="btn btn-block btn-primary btn-lg"><i class="fa fa-key"></i> &nbsp; <?php _e('Login','wpdm-premium-packages'); ?></button></div>

                        </div>
                        <hr style="margin: 15px 0"/>
                        <div class="row" style="margin-bottom: 10px">
                            <div class="col-md-12"><?php _e('Forgot Password?','wpdm-premium-packages'); ?> <a href="<?php echo wpdm_lostpassword_url(); ?>"><?php _e('Request New','wpdm-premium-packages'); ?></a></div>
                        </div>

                        <input type="hidden" name="redirect_to" value="<?php echo isset($log_redirect)?$log_redirect:$_SERVER['REQUEST_URI']; ?>" />

                    </form>
                    <?php do_action("wpdm_after_login_form"); ?>
                    </div>
                </div>
            </div>
            <div style="clear: both;"></div>
        </div>
    </div>

    <script>
        jQuery(function ($) {
            $.getScript('<?php echo WPDM_BASE_URL.'assets/js/validator.min.js'; ?>', function () {
                $('#registerform').validator();
            });
            var llbl = $('#registerform-submit').html();
            $('#registerform').submit(function () {

                $('#registerform-submit').html("<i class='fa fa-spin fa-spinner'></i> <?php _e('Please Wait...','wpdm-premium-packages'); ?>");
                $(this).ajaxSubmit({
                    success: function (res) {
                        if (!res.match(/success/)) {
                            $('form .alert-danger').hide();
                            $('#registerform').prepend("<div class='alert alert-danger'>"+res+"</div>");
                            $('#registerform-submit').html(llbl);
                            setTimeout(function () {
                                $('#registerform .alert').fadeOut();
                            }, 3000);
                        } else {
                            $('#registerform-submit').html("<i class='fa fa-check-circle'></i> <?php _e('Loading Payment Options...','wpdm-premium-packages'); ?>");
                            $('#wpdm-checkout').load(wpdm_ajax_url+"?action=payment_options");

                        }
                    }
                });
                return false;
            });

            $('#loginform').submit(function () {

                $('#loginform-submit').html("<i class='fa fa-spin fa-spinner'></i> <?php _e('Please Wait...','wpdm-premium-packages'); ?>");
                $(this).ajaxSubmit({
                    success: function (res) {
                        if (!res.match(/success/)) {
                            $('form .alert-danger').hide();
                            $('#loginform').prepend("<div class='alert alert-danger'><?php _e('Failed! Incorrect login info.','wpdm-premium-packages'); ?></div>");
                            $('#loginform-submit').html(llbl);
                            setTimeout(function () {
                                $('#loginform .alert').fadeOut();
                            }, 3000);
                        } else {
                            $('#loginform-submit').html("<i class='fa fa-check-circle'></i> <?php _e('Loading Payment Options...','wpdm-premium-packages'); ?>");
                            $('#wpdm-checkout').load(wpdm_ajax_url+"?action=payment_options");

                        }
                    }
                });
                return false;
            });

            $('body').on('click', '#checkout-login .alert', function () {
                $(this).fadeOut();
            });
        });
    </script>