<?php
/**
 * Cart Template
 *
 * This template can be overridden by copying it to yourtheme/download-manager/checkout-cart/cart.php.
 *
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$settings               = get_option('_wpdmpp_settings');
$currency_sign          = wpdmpp_currency_sign();
$currency_sign_before   = wpdmpp_currency_sign_position() == 'before' ? $currency_sign : '';
$currency_sign_after    = wpdmpp_currency_sign_position() == 'after' ? $currency_sign : '';
$guest_checkout         = ( isset($settings['guest_checkout']) && $settings['guest_checkout'] == 1 ) ? 1 : 0;
$login_required         = ! is_user_logged_in() && $guest_checkout == 0 ? true : false;
$wpdm_template          = new \WPDM\Template();

if ( is_array( $cart_data ) && count( $cart_data ) > 0 ) { ?>

    <div class="w3eden">

        <?php do_action( 'wpdmpp_before_cart' ); ?>

        <!-- Cart Form -->
        <form method="post" class="abc" action="" name="checkout_cart_form">
            <input name="wpdmpp_update_cart" value="1" type="hidden">
            <table class="wpdm_cart table">
                <thead>
                <tr class="cart_header">

                    <?php do_action( 'wpdmpp_cart_table_header_first' ); ?>

                    <th class="cart_item_remove" style="width:20px !important"></th>
                    <th class="cart_item_title"><?php _e("Item", "wpdm-premium-packages"); ?></th>
                    <th class="cart_item_unit_price"><?php _e("Unit Price", "wpdm-premium-packages"); ?></th>
                    <th class="cart_item_role_discount"><?php _e("Role Discount", "wpdm-premium-packages"); ?></th>
                    <th class="cart_item_coupon_code"><?php _e("Coupon Code", "wpdm-premium-packages"); ?></th>
                    <th class="cart_item_quantity"><?php _e("Quantity", "wpdm-premium-packages"); ?></th>
                    <th class="cart_item_subtotal amt"><?php _e("Total", "wpdm-premium-packages"); ?></th>

                    <?php do_action( 'wpdmpp_cart_table_header_last' ); ?>

                </tr>
                </thead>
                <tbody>
                <!-- Cart Items  -->
                <?php do_action( 'wpdmpp_cart_items_before' ); ?>
                <?php

                foreach ( $cart_data as $ID => $item ) {
                    $license = maybe_unserialize($item['license']);
                    $license = isset($license['info'], $license['info']['name'])?'<span class="ttip color-purple" title="'.esc_html($license['info']['description']).'">'.sprintf(__("%s License","wpdm-premium-packages"), $license['info']['name']).'</span>':'';
                    $cart_item_info = $license;
                    $cart_item_info = apply_filters("wpdmpp_cart_item_info", $cart_item_info, $item['ID']);
                    $thumb          = wpdm_thumb($item['ID'], array(50, 50), false);
                    $variations     = isset($item['variations']) ? "<small><i>" . implode(", ", $item['variations']) . "</i></small>" : '';

                    if ( isset( $item['coupon_amount'] ) ) {
                        $discount_amount    = $item['coupon_amount'];
                        $discount_style     = "style='color:#008000; text-decoration:underline;'";
                        $discount_title     = 'Discounted $' . $discount_amount . " for coupon code '{$item['coupon']}'";

                    } else {
                        $discount_amount    = "";
                        $discount_style     = "";
                        $discount_title     = "";
                    }

                    if (isset($item['error']) && $item['error'] != '') {
                        $coupon_style   = "border:1px solid #ff0000;";
                        $title          = $item['error'];
                    } else {
                        $coupon_style   = "";
                        $title          = "";
                    }

                    $item['coupon']         = isset($item['coupon']) ? $item['coupon'] : '';
                    $item['coupon_amount']  = isset($item['coupon_amount']) ? $item['coupon_amount'] : 0;
                    $item_total             = number_format((($item['price'] + $item['prices']) * $item['quantity']) - $item['coupon_amount'] - $item['discount_amount'], 2, ".", "");
                    ?>
                    <tr id='cart_item_<?php echo $ID; ?>'>

                        <?php do_action( 'wpdmpp_cart_item_col_first' , $item ); ?>

                        <td class='cart_item_remove'>
                            <a class='wpdmpp_cart_delete_item btn btn-xs btn-danger' href='#' onclick='return wpdmpp_remove_cart_item(<?php echo $ID; ?>)'><i class='fa fa-trash-o'></i></a>
                        </td>
                        <td class='cart_item_title'>
                            <a class='wpdmpp_cart_delete_item btn btn-xs btn-danger d-md-none d-lg-none' href='#' onclick='return wpdmpp_remove_cart_item(<?php echo $ID; ?>)'>
                                <i class='fa fa-trash-o'></i> <?php _e("Remove From Cart", "wpdm-premium-packages"); ?>
                            </a>
                            <div class='pull-left thumb'><?php echo $thumb; ?></div>
                            <a target=_blank href='<?php echo get_permalink($ID); ?>'><?php echo $item['post_title']; ?></a><br>
                            <?php echo $variations . ' ' . $cart_item_info; ?>
                            <div class='clear'></div>
                        </td>
                        <td class='cart_item_unit_price' <?php echo $discount_style; ?> >
                            <span class='d-md-none d-lg-none'><?php echo __("Unit Price", "wpdm-premium-packages"); ?>: </span>
                            <span class='ttip' title='<?php echo $discount_title; ?>'><?php echo $currency_sign_before . number_format($item['price'], 2, ".", "").$currency_sign_after; ?></span>
                        </td>
                        <td class='cart_item_role_discount'>
                            <span class='d-md-none d-lg-none'><?php echo __("Role Discount", "wpdm-premium-packages"); ?>: </span>
                            <?php echo $currency_sign_before . number_format($item['discount_amount'], 2, '.', '') . $currency_sign_after; ?>
                        </td>
                        <td class="cart_item_coupon_code">
                            <span class='d-md-none d-lg-none'><?php echo __("Coupon Code", "wpdm-premium-packages"); ?>: </span>
                            <input style='width:100px;<?php echo $coupon_style; ?>' title='<?php echo $title; ?>'
                                   type='text' name='cart_items[<?php echo $ID; ?>][coupon]' value='<?php echo $item['coupon']; ?>' id='<?php echo $ID; ?>' class='ttip input-sm form-control' size=3/>
                        </td>
                        <td class='cart_item_quantity'>
                            <span class='d-md-none d-lg-none'><?php echo __("Quantity", "wpdm-premium-packages"); ?>: </span>
                            <input type='number' style='width:60px' min='1' name='cart_items[<?php echo $ID; ?>][quantity]' value='<?php echo $item['quantity']; ?>' size=3 class=' input-sm form-control'/>
                        </td>
                        <td class='cart_item_subtotal amt'>
                            <span class='d-md-none d-lg-none'><?php echo __("Item Total", "wpdm-premium-packages"); ?>: </span>
                            <?php echo $currency_sign_before . number_format($item_total,2) . $currency_sign_after; ?>
                        </td>

                        <?php do_action( 'wpdmpp_cart_item_col_last', $item ); ?>

                    </tr>

                <?php } ?>
                <!-- Cart Items end -->

                <?php do_action( 'wpdmpp_cart_items_after' ); ?>

                <?php do_action('wpdmpp_cart_extra_row', $cart_data); ?>

                <!-- Cart Sub Total  -->
                <tr id="cart-total">
                    <td colspan="6" class="text-right " align="right"><?php echo __("Subtotal", "wpdm-premium-packages"); ?>:</td>
                    <td class="amt">
                        <span class="d-md-none d-lg-none"><?php echo __("Subtotal", "wpdm-premium-packages"); ?>: </span>
                        <strong id="wpdmpp_cart_subtotal"><?php echo $currency_sign_before . number_format($cart_subtotal,2) . $currency_sign_after; ?></strong>
                    </td>
                </tr>
                <!-- Cart Sub Total end  -->

                <!-- Cart Coupon Discount  -->
                <tr id="cart-total">
                    <td colspan="4" class="text-right ">
                        <div class="input-group input-group-sm" style="max-width: 220px">
                            <input type="text" name="coupon_code" class="form-control" value="<?php echo $cart_coupon['code']; ?>" placeholder="Coupon Code">
                            <span class="input-group-btn"><button class="btn btn-default" type="submit">Apply</button></span>
                        </div>
                    </td>
                    <td colspan="2" class="text-right " align="right"><?php echo __("Coupon Discount", "wpdm-premium-packages"); ?>:</td>
                    <td class="amt">
                        <span class="d-md-none d-lg-none"><?php echo __("Coupon Discount", "wpdm-premium-packages"); ?>: </span>
                        <span id="wpdmpp_cart_discount"><?php echo $currency_sign_before . $cart_coupon_discount . $currency_sign_after; ?></span>
                    </td>
                </tr>
                <!-- Cart Coupon Discount end -->

                <?php if (wpdmpp_tax_active()) { ?>
                    <!-- Cart Tax  -->
                    <tr id="cart-tax">
                        <td colspan="6" class="text-right " align="right"><?php echo __("Tax", "wpdm-premium-packages"); ?>:</td>
                        <td class="amt" id="wpdmpp_cart_tax">
                            <span class="d-md-none d-lg-none"><?php echo __("Tax", "wpdm-premium-packages"); ?>: </span>
                            <?php echo $currency_sign_before . $cart_tax . $currency_sign_after; ?>
                        </td>
                    </tr>
                    <!-- Cart Tax end -->
                <?php } ?>

                <!-- Cart Total Including Tax -->
                <tr id="cart-total-with-tax">
                    <td colspan="6" class="text-right " align="right"><?php echo __("Total", "wpdm-premium-packages"); ?>:</td>
                    <td class="amt">
                        <strong><span class="d-md-none d-lg-none"><?php echo __("Total", "wpdm-premium-packages"); ?>: </span></strong>
                        <strong id="wpdmpp_cart_grand_total"><?php echo $currency_sign_before . number_format($cart_total_with_tax,2) . $currency_sign_after; ?></strong>
                    </td>
                </tr>
                <!-- Cart Total Including Tax end -->

                <!-- Cart buttons -->
                <tr>
                    <td colspan="4">
                        <button type="button" class="btn btn-info " onclick="location.href='<?php echo $settings['continue_shopping_url']; ?>'">
                            <i class="fa fa-white fa-long-arrow-left"></i>&nbsp;<?php echo apply_filters( "wpdmpp_cart_continue_shopping_button_label", __( "Continue Shopping", "wpdm-premium-packages" ) ); ?>
                        </button>
                        <button id="save-cart" type="button" class="btn btn-secondary">
                            <i class="fa fa-save"></i>&nbsp;<?php echo apply_filters( "wpdmpp_save_cart_button_label", __( "Save Cart", "wpdm-premium-packages" ) ); ?>
                        </button>
                    </td>
                    <td colspan="3" class="text-right" align="right">
                        <button class="btn btn-primary" type="button" onclick="document.checkout_cart_form.submit();">
                            <i class="fa fa-white fa-check"></i> <?php echo apply_filters( "wpdmpp_update_cart_button_label", __( "Update Cart", "wpdm-premium-packages" ) ); ?>
                        </button>
                    </td>
                </tr>
                <!-- Cart buttons end -->
                </tbody>
            </table>

        </form>
        <!-- Cart Form end-->

        <?php do_action( 'wpdmpp_after_cart' ); ?>

        <!-- Saved cart -->
        <?php include wpdm_tpl_path('checkout-cart/cart-save.php', WPDMPP_BASE_DIR . '/templates/'); ?>
        <!-- Saved cart end -->

        <!-- Cart Checkout-->
        <div id="wpdm-checkout">
            <?php
            if($login_required){
                echo $wpdm_template->fetch('checkout-cart/checkout-login-register.php', WPDMPP_BASE_DIR.'templates');
            } else {
                echo $wpdm_template->fetch('checkout-cart/checkout.php', WPDMPP_BASE_DIR.'templates');
            }
            ?>
        </div>
        <!-- Cart Checkout end-->

        <?php do_action( 'wpdmpp_after_checkout_form' ); ?>

    </div>

    <?php

} else {
    // Cart is empty
    include wpdm_tpl_path('checkout-cart/cart-empty.php', WPDMPP_BASE_DIR . '/templates/');
}