<?php
/*
Template Name: Homepage ( Optimus )
*/
if (!defined('ABSPATH')) exit;

define('THENEXT_HIDE_PAGE_HEADER',1);

get_header();

?>


    <section class="header-area-home" id="header-area-home">
	    <?php get_template_part('homepage','top'); ?>
    </section>

    <section class="featured-content-area" id="featured-content-area">
        <div class="container">
            <div class="row">
				<?php
				$clrs = array('success','info','primary','warning');
				for($i=1; $i<=4; $i++):

                    $page_id = intval(WPEdenThemeEngine::NextGetOption("home_featured_page_o_".$i));
                    $page  = get_post($page_id);
                    $meta = get_post_meta($page_id, 'wpeden_post_meta', true);
                    $url = get_permalink($page_id);
					?>
                <div class="col-md-3"><a href="<?php echo get_permalink($page_id); ?>">
                    <div class="panel panel-<?php echo $clrs[$i-1]; ?> panel-featured-content  text-center">
                        <div class="panel-heading"><?php echo esc_attr($page->post_title); ?></div>
                        <div class="panel-body">
                            <div class="diamond filled bg-<?php echo $clrs[$i-1]; ?> wow zoomIn" data-wow-delay="500ms">
                            <i class="lineicon <?php echo $meta['icon']; ?>"></i>
                            </div>

                        </div>
                    </div></a>
                </div>
				<?php endfor; ?>

            </div>
        </div>
    </section>

    <section class="why-us" id="why-us">

        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center section-intro">
                    <h2 class="header-boxed wow fadeInUp"  data-wow-delay="100ms" data-wow-iteration="1"><span><?php echo WPEdenThemeEngine::NextGetOption('home_feature_title_o','Why Us?');?></span></h2>
                    <p class="lead wow fadeInUp"  data-wow-delay="600ms"><?php echo WPEdenThemeEngine::NextGetOption('home_feature_desc_o','Simple and only reason, We are the Best! Let\'s see some highlights:'); ?></p>
                </div>
                <div class="col-md-12 highlight-boxes">
	            <?php
	                    $clrs = array('success','info','warning', 'danger', 'warning', 'info' );
	                    for($i=1; $i<=6; $i++):

							$page_id = WPEdenThemeEngine::NextGetOption("home_feature_page_o_".$i);
							$page  = get_post($page_id);
							$meta = get_post_meta($page_id, 'wpeden_post_meta', true);
							$url = esc_url(get_permalink($page_id));
							$d = $i;
							if($i > 3) $d = $i-3;
				?>

                <div class="col-md-4 col-sm-6 wow fadeInUp" data-wow-delay="<?php echo $d*100; ?>ms">
                    <div class="featured-content-box text-center">
                        <i class="<?php echo $meta['icon']; ?> ico-lg text-<?php echo $clrs[$i-1]; ?>"></i>

                        <h3><?php echo esc_attr($page->post_title); ?></h3>
                        <p><?php echo esc_attr($meta['sub_heading']); ?></p>
                        <a class="btn btn-<?php echo $clrs[$i-1]; ?>" href="<?php echo get_permalink($page_id); ?>"><?php _e('Explore','optimus'); ?></a>
                    </div>
                </div>

				<?php endfor; ?>

                </div>


            </div>
        </div>

    </section>

    <section class="out-team" id="out-team" >

    <div class="container">
    <div class="row">
    <div class="col-md-12 text-center section-intro">
        <h2 class="header-boxed wow fadeInUp"  data-wow-delay="100ms" data-wow-iteration="1"><span><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_team_title','Our Team'); ?></span></h2>
        <p class="lead"><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_team_desc','Awesome Magicians Behind'); ?></p>
    </div>

			<?php
			$clrs = array('success','info','warning', 'danger', 'warning', 'info' );
			for($i=1; $i<=4; $i++):

				$uid = WPEdenThemeEngine::NextGetOption("home_optimus_team_member_".$i);

				$user  = get_userdata($uid);


				if($user){


					?>
            <div class="col-sm-6 col-md-3">
	            <div class="card hovercard">
		            <div class="cardheader" style="background: url(<?php echo esc_attr(get_the_author_meta( '__thenext_profile_bg_img', $user->ID )); ?>);background-size: cover">

		            </div>
		            <div class="avatar">
			            <img src="<?php echo wpeden_dynamic_thumb(esc_attr(get_the_author_meta( '__thenext_prifle_pic', $user->ID )), array(150, 150)); ?>" alt="Prfile Pic">
		            </div>
		            <div class="info">
			            <div class="title">
				            <?php echo $user->display_name?$user->display_name:$user->user_login; ?>
			            </div>
			            <div class="desc"><?php echo esc_attr(get_the_author_meta( '__thenext_designation', $uid )); ?></div>

		            </div>
		            <div class="bottom">
			            <a href="<?php echo esc_attr(get_the_author_meta( '__thenext_twitter', $uid )); ?>" class="btn-social btn-twitter btn-sm">
				            <i class="fa fa-twitter"></i>
			            </a>
			            <a href="<?php echo esc_attr(get_the_author_meta( '__thenext_googleplus', $uid )); ?>" rel="publisher" class="btn-social btn-google-plus btn-sm">
				            <i class="fa fa-google-plus"></i>
			            </a>
			            <a href="<?php echo esc_attr(get_the_author_meta( '__thenext_facebook', $uid )); ?>" rel="publisher" class="btn-social btn-facebook btn-sm">
				            <i class="fa fa-facebook"></i>
			            </a>
			            <a href="<?php echo esc_attr(get_the_author_meta( '__thenext_linkedin', $uid )); ?>" rel="publisher" class="btn-social btn-linkedin btn-sm">
				            <i class="fa fa-linkedin"></i>
			            </a>
		            </div>
	            </div>
            </div>
				<?php } endfor; ?>

    </div>
    </div>
    </section>


    <section class="client-reviews" id="client-reviews">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center section-intro">
                    <h2 class="header-boxed wow fadeInUp"  data-wow-delay="100ms" data-wow-iteration="1"><span><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_review_title','Customer Reviews'); ?></span></h2>
                    <p class="lead"><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_review_desc','Our Customers Think, We Are Awesome:'); ?></p>
                </div>
                <?php
                    $q = new WP_Query('post_type=review&posts_per_page=3');
                    while($q->have_posts()):
                        $q->the_post();
                        $meta = get_post_meta(get_the_ID(), 'wpeden_post_meta', true);
                ?>
                <div class="col-md-4">
                    <div class="speach">
                        <?php the_content(); ?>
                        <div class="media person">
                            <div class="pull-left">
                                <img src="<?php echo wpeden_dynamic_thumb($meta['picture'], array(90, 90)); ?>" class="img-circle">
                            </div>
                            <div class="media-body">
                                <b><?php echo $meta['name']; ?></b><br/>
                                <?php echo $meta['designation']; ?>
                            </div>
                        </div>
                    </div>
                </div>
                        <?php endwhile; ?>


            </div>
        </div>
    </section>

    <section class="pricing" id="pricing">
    <div class="container">
    <div class="row">
    <div class="col-md-12 text-center section-intro">
        <h2 class="header-boxed wow fadeInUp"  data-wow-delay="100ms" data-wow-iteration="1"><span><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_pricing_title','Pricing'); ?></span></h2>
        <p class="lead"><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_pricing_desc','Get from the best offers:'); ?></p>
    </div>

    <div class="col-md-12">
        <?php

            for($i=1; $i<=4; $i++){
                $pid = WPEdenThemeEngine::NextGetOption("home_optimus_pricing_col_".$i);
                TheNextChild::PricingPackage(array('id'=>$pid,'echo' => 1));
            }
        ?>

    </div>

    </div>
    </div>
    </section>

    <section class="curious" id="curious">
    <div class="container">
    <div class="row">
    <div class="col-md-12 text-center section-intro">
        <h2 class="header-boxed"><span><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_contact_title','Feeling Curious?'); ?></span></h2>
        <p class="lead"><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_contact_desc','Simple and only reason, We are the Best! Let\'s see some highlights:'); ?></p>
    </div>
        <div class="col-md-6">
            <div class="contact-form">
            <form class="row" method="post" action="" id="contact-form">
                <div class="col-md-6">
                    <div class="form-group"><label>Your name here</label> <input type="text" name="contact[name]" class="form-control"></div>
                </div>
                <div class="col-md-6">
                    <div class="form-group"><label>Your e-mail</label> <input type="email" name="contact[email]" class="form-control"></div>
                </div>
                <div class="col-md-12">
                    <div class="form-group"><label>Your Message</label> <textarea name="contact[message]" rows="6" class="form-control"></textarea></div>
                    <div class="send_result"></div>
                </div>
                <div class="col-md-12">
                    <button id="btn-submit" type="submit" class="btn btn-primary btn-lg btn-block">SUBMIT</button>
                </div>
            </form>
            </div>
        </div>
        <div class="col-md-3">
            <div class="featured-content-box text-center">
                <div class="circle img-circle filled bg-info feature-icon">
                    <i class="lineicon tn-mobile"></i>
                </div>

                <h3>Phone</h3>
                <p><?php echo WPEdenThemeEngine::NextGetOption('contact_phone'); ?></p>

            </div>

            <div class="featured-content-box text-center">
                <div class="circle img-circle filled bg-info  bg-info feature-icon">
                    <i class="lineicon tn-email"></i>
                </div>

                <h3>Email</h3>
                <p><?php echo WPEdenThemeEngine::NextGetOption('contact_email'); ?></p>

            </div>

        </div>
        <div class="col-md-3">
            <div class="panel panel-default panel-subscribe panel-subscribe-narrow panel-subscribe-light panel-subscribe-vert">
                <div class="panel-body">
                    <div class="media text-center">
                        <img src="<?php echo get_stylesheet_directory_uri() ?>/imgs/email2.png">
                        <div class="media-body">
                            <h3><?php echo WPEdenThemeEngine::NextGetOption('home_optimus_subs_title', 'Subscribe'); ?></h3>
                            <?php echo WPEdenThemeEngine::NextGetOption('home_optimus_subs_desc', 'Do not ever miss a single news! It just will be dropped in your inbox in right time.'); ?>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">

                    <form method="post">
                        <div class="form-group">
                            <input type="text" name="subs[fullname]" placeholder="Full Name" id="fname1" class="form-control">
                        </div>
                        <div class="input-group input-block">
                            <input type="email" name="subs[email]" placeholder="Your Email" class="form-control">
                        <span class="input-group-btn">
                        <button class="btn btn-inverse btn-block" type="submit">Submit</button>
                    </span>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    </div>
    </section>



<?php get_footer(); ?>
