<?php
/**
 * Plugin Name: WPDM - Import Download Monitor Data
 * Description: Import Download Monitor Data to Download Manager
 * Plugin URI: https://www.wpdownloadmanager.com/download/import-download-monitor/
 * Author: Shaon
 * Version: 2.0.1
 * Author URI: https://www.wpdownloadmanager.com/
 */
if ( defined('WPDM_VERSION') ) {

    add_filter( 'add_wpdm_settings_tab', 'wpdm_import_download_monitor_tab' );

    function wpdm_import_download_monitor_tab( $stabs ){
        $stabs['dlmonitor-import'] = wpdm_create_settings_tab('dlmonitor-import', 'Download Monitor Import', 'wpdm_import_download_monitor', $icon = 'fas fa-file-import');
        return $stabs;
    }

    function wpdm_import_download_monitor(){
        global $wpdb, $wp_roles;

        set_time_limit(0);

        if( isset( $_POST['__wpdm_dlm_import_data'] ) ) {

            $allposts = $wpdb->get_results("select * from {$wpdb->prefix}posts where post_type='dlm_download'");

            $wpdb->query("update {$wpdb->prefix}posts set post_type='wpdmpro' where post_type='dlm_download'");
            $wpdb->query("update {$wpdb->prefix}term_taxonomy set `taxonomy`='wpdmcategory' where `taxonomy`='dlm_download_category'");
            $wpdb->query("update {$wpdb->prefix}term_taxonomy set `taxonomy`='post_tag' where `taxonomy`='dlm_download_tag'");
            $wpdb->query("update {$wpdb->prefix}postmeta set meta_key='__wpdm_download_count' where meta_key='_download_count'");

            $guests     = serialize(array('guest'));
            $roles      = $wp_roles->role_names;
            $roles      = array_keys($roles);
            $members    = serialize($roles);

            $wpdb->query("update {$wpdb->prefix}postmeta set meta_key='__wpdm_access', meta_value='{$guests}' where meta_key='_members_only' and meta_value='no'");
            $wpdb->query("update {$wpdb->prefix}postmeta set meta_key='__wpdm_access', meta_value='{$members}' where meta_key='_members_only' and meta_value='yes'");

            foreach($allposts as $dlmp){
                $dlmfvs = $wpdb->get_results("select * from {$wpdb->prefix}posts where post_type='dlm_download_version' and post_parent='{$dlmp->ID}'");
                    $files = array();
                    foreach($dlmfvs as $dlmfv) {
                        $tfiles = get_post_meta($dlmfv->ID, '_files', true);
                        $tfiles = json_decode($tfiles);
                        $files = array_merge($files, $tfiles);
                    }
                    $files = array_unique($files);
                    update_post_meta($dlmp->ID, '__wpdm_files', $files);
            }
            die('All Download Monitor Data Imported Successfully!');
        }
        $data = wp_count_posts('dlm_download');
        $total = array_sum((array)$data);
        ?>
        <div class="panel panel-default">
            <div class="panel-heading"><b><?php _e('Import from Download Monitor','download-manager'); ?></b></div>
            <div class="panel-body">
                <input type="hidden" name="__wpdm_dlm_import_data" value="1" />
                <div class="alert alert-info"><?php echo $total; ?> Download Monitor Post(s) Found</div>
                Just Click Save Settings Button To Import All Download Monitor Data!
            </div>
        </div>
    <?php
    }
}