<?php
/**
 * Plugin Name: WPDM - Google Drive
 * Description: Google Drive Storage Access for WPDM
 * Plugin URI: https://www.wpdownloadmanager.com/
 * Author: WordPress Download Manager
 * Version: 1.5.5
 * Author URI: https://www.wpdownloadmanager.com/
 * Update URI: wpdm-google-drive
 * Text Domain: wpdm-google-drive
 */

if (defined('WPDM_VERSION')) {

    if (!defined('WPDM_CLOUD_STORAGE'))
        define('WPDM_CLOUD_STORAGE', 1);

    add_action('plugin_loaded', function (){
        load_plugin_textdomain('wpdm-google-drive', WP_PLUGIN_URL . "/wpdm-google-drive/languages/", 'wpdm-google-drive/languages/');
    });

    class WPDMGoogleDrive
    {
        function __construct()
        {

            add_action("wpdm_cloud_storage_settings", array($this, "Settings"));
            add_action('wpdm_attach_file_metabox', array($this, 'BrowseButton'));
	        add_filter('update_plugins_wpdm-google-drive', [$this, "updatePlugin"], 10, 4);

        }


        function Settings()
        {
            global $current_user;

            $wpdm_google_drive = maybe_unserialize(get_option('__wpdm_google_drive', array()));
            ?>
            <div class="panel panel-default">
                <div class="panel-heading">
                    <div class="pull-right">
                        <a href="https://console.cloud.google.com/apis/credentials" target="_blank" class="btn btn-xs btn-info"><?php _e('Get API credentials', 'wpdm-google-drive'); ?></a>
                        <a href="https://console.developers.google.com/start/api?id=picker&credential=client_key" target="_blank" class="btn btn-xs btn-info"><?php _e('Enable Picker API', 'wpdm-google-drive'); ?></a>
                    </div>
                    <b><?php _e('Google Drive API Credentials', 'wpdm-google-drive'); ?></b>
                </div>

                <table class="table">


                    <tr>
                        <td><?php _e('App ID','wpdm-google-drive');?></td>
                        <td><input type="text" name="__wpdm_google_drive[app_id]" class="form-control"
                                   value="<?php echo isset($wpdm_google_drive['app_id']) ? $wpdm_google_drive['app_id'] : ''; ?>"/>
                        </td>
                    </tr>
                    <tr>
                        <td><?php _e('API Key','wpdm-google-drive');?></td>
                        <td><input type="text" name="__wpdm_google_drive[api_key]" class="form-control"
                                   value="<?php echo isset($wpdm_google_drive['api_key']) ? $wpdm_google_drive['api_key'] : ''; ?>"/>
                        </td>
                    </tr>
                    <tr>
                        <td><?php _e('Client ID','wpdm-google-drive');?></td>
                        <td><input type="text" name="__wpdm_google_drive[client_id]" class="form-control"
                                   value="<?php echo isset($wpdm_google_drive['client_id']) ? $wpdm_google_drive['client_id'] : ''; ?>"/>
                        </td>
                    </tr>
                    <tr>
                        <td><?php _e('Client Secret','wpdm-google-drive');?></td>
                        <td><input type="text" name="__wpdm_google_drive[client_secret]" class="form-control"
                                   value="<?php echo isset($wpdm_google_drive['client_secret']) ? $wpdm_google_drive['client_secret'] : ''; ?>"/>
                        </td>
                    </tr>

                </table>
                <div class="panel-footer">
                    <b><?php _e('Redirect URI:','wpdm-google-drive');?></b> &nbsp; <input onclick="this.select()" type="text" class="form-control" style="background: #fff;cursor: copy;display: inline;width: 400px" readonly="readonly" value="<?php echo admin_url('?page=wpdm-google-drive'); ?>" />
                </div>
            </div>


        <?php
        }



        function BrowseButton()
        {

            $wpdm_google_drive = maybe_unserialize(get_option('__wpdm_google_drive', array()));
            include dirname(__FILE__).'/src/picker.php';

        }

	    function updatePlugin($update, $plugin_data, $plugin_file, $locales){
		    $id = basename(__DIR__);
		    $latest_versions = WPDM()->updater->getLatestVersions();
		    $latest_version = wpdm_valueof($latest_versions, $id);
		    $access_token = wpdm_access_token();
		    $update = [];
		    $update['id']           = $id;
		    $update['slug']         = $id;
		    $update['url']          = $plugin_data['PluginURI'];
		    $update['tested']       = true;
		    $update['version']      = $latest_version;
		    $update['package']      = "https://www.wpdownloadmanager.com/?wpdmdl=25300";
		    return $update;
	    }


    }

    new WPDMGoogleDrive();

}


