<?php
if(!defined('ABSPATH')) die();
if($wpdm_google_drive['api_key'] == '' || $wpdm_google_drive['client_id'] == ''){
    ?>
    <div class="w3eden">

        <a target="_blank" href="<?= admin_url('edit.php?post_type=wpdmpro&page=settings&tab=cloud-storage'); ?>" style="margin-top: 10px" title="Google Drive"  class="btn btn-danger btn-block"><span class="left-icon"><i class="fa fa-google"></i></span><?php _e( 'Configure','wpdm-google-drive');?></a>

    </div>
    <?php
} else {
?>

    <script type="text/javascript">


        // Authorization scopes required by the API; multiple scopes can be
        // included, separated by spaces.
        //const SCOPES = 'https://www.googleapis.com/auth/drive.metadata.readonly';
        const SCOPES = 'https://www.googleapis.com/auth/drive';

        // TODO(developer): Set to client ID and API key from the Developer Console
        const CLIENT_ID = '<?php echo $wpdm_google_drive['client_id'];?>';
        const API_KEY = '<?php echo $wpdm_google_drive['api_key'];?>';

        // TODO(developer): Replace with your own project number from console.developers.google.com.
        const APP_ID = '<?php echo $wpdm_google_drive['app_id'];?>';

        let tokenClient;
        let accessToken = null;
        let pickerInited = false;
        let gisInited = false;


        //document.getElementById('authorize_button').style.visibility = 'hidden';
        //document.getElementById('signout_button').style.visibility = 'hidden';

        /**
         * Callback after api.js is loaded.
         */
        function gapiLoaded() {
            gapi.load('picker', intializePicker);
        }

        /**
         * Callback after the API client is loaded. Loads the
         * discovery doc to initialize the API.
         */
        function intializePicker() {
            pickerInited = true;
            maybeEnableButtons();
        }

        /**
         * Callback after Google Identity Services are loaded.
         */
        function gisLoaded() {
            tokenClient = google.accounts.oauth2.initTokenClient({
                client_id: CLIENT_ID,
                scope: SCOPES,
                callback: '', // defined later
            });
            gisInited = true;
            maybeEnableButtons();
        }

        /**
         * Enables user interaction after all libraries are loaded.
         */
        function maybeEnableButtons() {
            if (pickerInited && gisInited) {
                document.getElementById('btn-google-drive').style.visibility = 'visible';
            }
        }

        /**
         *  Sign in the user upon button click.
         */
        function handleAuthClick() {
            tokenClient.callback = async (response) => {
                if (response.error !== undefined) {
                    throw (response);
                }
                accessToken = response.access_token;
                //document.getElementById('signout_button').style.visibility = 'visible';
                //document.getElementById('btn-google-drive').innerText = 'Refresh';
                await createPicker();
            };

            if (accessToken === null) {
                // Prompt the user to select a Google Account and ask for consent to share their data
                // when establishing a new session.
                tokenClient.requestAccessToken({prompt: 'consent'});
            } else {
                // Skip display of account chooser and consent dialog for an existing session.
                tokenClient.requestAccessToken({prompt: ''});
            }
        }


        /**
         *  Create and render a Picker object for searching images.
         */
        function createPicker() {
            //const view = new google.picker.View(google.picker.ViewId.DOCS);
            const view = new google.picker.DocsView().setParent('root').setIncludeFolders(true);

            //view.setMimeTypes('image/png,image/jpeg,image/jpg');
            //view.setMimeTypes('*');
            const picker = new google.picker.PickerBuilder()
                .enableFeature(google.picker.Feature.NAV_HIDDEN)
                .enableFeature(google.picker.Feature.MULTISELECT_ENABLED)
                .setDeveloperKey(API_KEY)
                .setAppId(APP_ID)
                .setOAuthToken(accessToken)
                .addView(view)
                .addView(new google.picker.DocsUploadView())
                .setCallback(pickerCallback)
                .build();
            picker.setVisible(true);
        }

        /**
         * Displays the file details of the user's selection.
         * @param {object} data - Containers the user selection from the picker
         */
        /*function pickerCallback(data) {
            if (data.action === google.picker.Action.PICKED) {
                document.getElementById('content').innerText = JSON.stringify(data, null, 2);
            }
        }*/

        function pickerCallback(data) {

            if (data.action === google.picker.Action.PICKED) {
                var doc = data[google.picker.Response.DOCUMENTS][0];
                console.log(data);

                var no_of_files = data.docs.length;

                data.docs.forEach(function (file) {

                    var id = file.id;
                    var downloadurl = 'https://docs.google.com/uc?authuser=0&id='+id+'&export=download';
                    var name = file.name;
                    var size = (file.sizeBytes/1024/1024).toFixed(2)+' MB';

                    var ext = 'png';
                    var ext = name.substr(name.lastIndexOf('.') + 1);

                    var file = downloadurl;
                    var icon = "<?php echo WPDM_BASE_URL; ?>assets/file-type-icons/" + ext + ".png";
			        <?php if(version_compare(WPDM_VERSION, '4.0.0', '>')){  ?>
                    var _file = {};
                    _file.filetitle = name;
                    _file.filepath = file;
                    _file.fileindex = id;
                    _file.preview = icon;

                    wpdm_attach_file(_file);

			        <?php } else { ?>

                    jQuery('#wpdmfile').val(file+"#"+name);
                    jQuery('#cfl').html('<div><strong>'+name+'</strong>').slideDown();

			        <?php } ?>

                });

            }
        }
    </script>
<script type="text/javascript">

/*

    // The Browser API key obtained from the Google Developers Console.
    var developerKey = '<?php echo $wpdm_google_drive['api_key'];?>';

    // The Client ID obtained from the Google Developers Console. Replace with your own Client ID.
    var clientId = "<?php echo $wpdm_google_drive['client_id'];?>";

    // Scope to use to access user's photos.
    var scope = ['https://www.googleapis.com/auth/drive'];

    var pickerApiLoaded = false;
    var oauthToken;

    // Use the API Loader script to load google.picker and gapi.auth.
    function onApiLoad() {
        //gapi.load('auth', {'callback': onAuthApiLoad});
        //gapi.load('picker', {'callback': onPickerApiLoad});
    }

    function onAuthApiLoad() {
        console.log('ON API LOAD...');
        window.gapi.auth.authorize(
            {
                'client_id': clientId,
                'scope': scope,
                'immediate': false
            },
            handleAuthResult);
    }

    function onPickerApiLoad() {
        pickerApiLoaded = true;
        console.log('Picker Api Loaded...');
        createPicker();
    }

    function handleAuthResult(authResult) {
        console.log(authResult);
        if (authResult && !authResult.error) {
            oauthToken = authResult.access_token;
            console.log(oauthToken);
            gapi.load('picker', {'callback': onPickerApiLoad});

        }
    }

    // Create and render a Picker object for picking user Photos.
    function createPicker() {
        if (pickerApiLoaded && oauthToken) {

            //var docsView = new google.picker.DocsView(google.picker.ViewId.DOCS);
            //docsView.setParent('ROOT');
            //docsView.setSelectFolderEnabled(true);
            //docsView.setIncludeFolders(true);

            var picker = new google.picker.PickerBuilder().
            enableFeature(google.picker.Feature.MULTISELECT_ENABLED).
            //addView(google.picker.ViewId.DOCS).
            //addView(google.picker.ViewId.FOLDERS).
            addView(new google.picker.DocsView().setParent('root').setIncludeFolders(true)).
            addView(new google.picker.DocsUploadView()).
            setOAuthToken(oauthToken).
            setDeveloperKey(developerKey).
            setCallback(pickerCallback).
            build();
            picker.setVisible(true);
        }
    }

    // A simple callback implementation.
    function pickerCallback(data) {

        if (data[google.picker.Response.ACTION] == google.picker.Action.PICKED) {
            var doc = data[google.picker.Response.DOCUMENTS][0];
            console.log(data);

            var no_of_files = data.docs.length;

            data.docs.forEach(function (file) {

                var id = file.id;
                var downloadurl = 'https://docs.google.com/uc?authuser=0&id='+id+'&export=download';
                var name = file.name;
                var size = (file.sizeBytes/1024/1024).toFixed(2)+' MB';

                var ext = 'png';
                var ext = name.substr(name.lastIndexOf('.') + 1);

                var file = downloadurl;
                var icon = "<?php echo WPDM_BASE_URL; ?>assets/file-type-icons/" + ext + ".png";
                <?php if(version_compare(WPDM_VERSION, '4.0.0', '>')){  ?>
                var _file = {};
                _file.filetitle = name;
                _file.filepath = file;
                _file.fileindex = id;
                _file.preview = icon;

                wpdm_attach_file(_file);

                <?php } else { ?>

                jQuery('#wpdmfile').val(file+"#"+name);
                jQuery('#cfl').html('<div><strong>'+name+'</strong>').slideDown();

                <?php } ?>

            });

        }

    }

    function gisLoaded() {
        // TODO(developer): Replace with your client ID and required scopes
        tokenClient = google.accounts.oauth2.initTokenClient({
            client_id: clientId,
            scope: scope,
            callback: '', // defined later
        });
        gisInited = true;
    }


    jQuery(function () {
        jQuery('#btn-google-drive').click(function () {
            gapi.load('auth', {'callback': onAuthApiLoad});
            return false;
        });
    }); */
</script>

<div class="w3eden">

<div id="result"></div>
<!-- The Google API Loader script. -->
    <a href="#" id="btn-google-drive" style="margin-top: 10px" title="Google Drive" onclick="handleAuthClick()" class="btn wpdm-google btn-block">Google Drive</a>
</div>

    <script async defer src="https://apis.google.com/js/api.js" onload="gapiLoaded()"></script>
    <script async defer src="https://accounts.google.com/gsi/client" onload="gisLoaded()"></script>
<style>.picker.picker-dialog{ overflow: hidden !important; }</style>
<?php }
