<?php
/*
Plugin Name: WPDM - Dropbox Explorer
Description: Dropbox Explorer for WordPress Download Manager
Plugin URI: https://www.wpdownloadmanager.com/download/dropbox-explorer/
Author: WordPress Download Manager
Version: 1.6.0
Author URI: http://www.wpdownloadmanager.com/
Update URI: wpdm-dropbox
*/



if (defined('WPDM_VERSION')) {
    if (!defined('WPDM_CLOUD_STORAGE'))
        define('WPDM_CLOUD_STORAGE', 1);
    $wpdm_dropbox = maybe_unserialize(get_option('__wpdm_dropbox', array()));

    //include dirname(__FILE__).'/libs/DropboxTeam.php';

    if(version_compare(WPDM_VERSION, '4.0.0', '<') || version_compare(phpversion(), '7.0.0', '<') || wpdm_valueof($wpdm_dropbox, 'account') !== 'single')
        include dirname(__FILE__).'/libs/dropbox-choser.php';
    else
        include dirname(__FILE__).'/libs/dropbox.php';


add_filter("update_plugins_wpdm-dropbox", function ($update, $plugin_data, $plugin_file, $locales){
    $id = basename(__DIR__);
    $latest_versions = function_exists('WPDM') ? WPDM()->updater->getLatestVersions() : '1.0.0';
    $latest_version = wpdm_valueof($latest_versions, $id);
    $update = [];
    $update['id']           = $id;
    $update['slug']         = $id;
    $update['url']          = $plugin_data['PluginURI'];
    $update['tested']       = true;
    $update['version']      = $latest_version;
    $update['package'] = 'https://www.wpdownloadmanager.com/?wpdmdl=26131';
    return $update;
}, 10, 4);

}
