<?php
 
if ( ! isset( $content_width ) ) $content_width = 960;

define("WPDM_THEME_SUPPORT", true);

require_once(dirname(__FILE__)."/admin/engine.php");
require_once(dirname(__FILE__)."/libs/nav-menu-walker.class.php");
require_once(dirname(__FILE__)."/modules/colorbox/colorbox.php");
require_once(dirname(__FILE__)."/modules/widget-styles.php");
require_once(dirname(__FILE__)."/wpmp-functions.php");


//generate thumbnail 
function centrino_thumb($post, $size='', $extra = array(), $echo = true){
    $size = $size?$size:'large';
    $class = isset($extra['class'])?$extra['class']:'';
    if(is_array($size))
    {
        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full');
        $large_image_url = $large_image_url[0];
        if($large_image_url!=''){
            $path = str_replace(site_url('/'), ABSPATH, $large_image_url);
            $thumb = centrino_dynamic_thumb($path, $size);
            $thumb = str_replace(ABSPATH, site_url('/'), $thumb);
            $alt = get_post_meta(get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true);
            $img = "<img src='".$thumb."' alt='{$alt}' class='{$class}' />";
            if($echo) { echo $img; return; }
            else
                return $img;
        }
    }
    if($echo&&has_post_thumbnail($post->ID ))
    echo get_the_post_thumbnail($post->ID, $size, $extra );
    else if(!$echo&&has_post_thumbnail($post->ID ))
    return get_the_post_thumbnail($post->ID, $size, $extra );  
    else if($echo)
    echo "";
    else
    return "";
    
}
    

//post thumbnail function
function centrino_post_thumb($size='', $echo = true, $extra = null){
    global $post;
    $size = $size?$size:'thumbnail';
    $class = isset($extra['class'])?$extra['class']:'';
    $alt = $post->post_title;
    if(is_array($size))
    {
        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full');
        $large_image_url = $large_image_url[0];
        if($large_image_url!=''){
            $path = str_replace(site_url('/'), ABSPATH, $large_image_url);
            $thumb = centrino_dynamic_thumb($path, $size);
            $thumb = str_replace(ABSPATH, site_url('/'), $thumb);
            $alt = get_post_meta(get_post_thumbnail_id($post->ID), '_wp_attachment_image_alt', true);
            $img = "<img src='".$thumb."' alt='{$alt}' class='{$class}' />";
            if($echo) { echo $img; return; }
            else
            return $img;
        }
    }
    if($echo&&has_post_thumbnail($post->ID ))
    echo get_the_post_thumbnail($post->ID, $size, $extra );    
    else if(!$echo&&has_post_thumbnail($post->ID ))
    return get_the_post_thumbnail($post->ID, $size, $extra );  
    else if($echo)
    echo "";
    else
    return "";
}

//post thumbnail url
function centrino_post_thumb_url($size='', $echo = true, $extra = null){
    global $post;
    $size = $size?$size:'thumbnail';
    if(is_array($size))
    {
        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full');
        $large_image_url = $large_image_url[0];
        if($large_image_url!=''){
            $path = str_replace(site_url('/'), ABSPATH, $large_image_url);
            $thumb = centrino_dynamic_thumb($path, $size);
            $thumb = str_replace(ABSPATH, site_url('/'), $thumb);
            return $thumb;
        }
    }
    $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full');
    $large_image_url = $large_image_url[0];
    return esc_url($large_image_url);
}

//genrate thumbnail url
function centrino_thumb_url($image, $size='', $echo = true, $extra = null){
    global $post;
    $size = $size?$size:'thumbnail';
    if(is_array($size))
    {        
        $large_image_url = $image;
        if($large_image_url!=''){
            $path = str_replace(site_url('/'), ABSPATH, $large_image_url);
            $thumb = centrino_dynamic_thumb($path, $size);
            $thumb = str_replace(ABSPATH, site_url('/'), $thumb);
            return esc_url($thumb);
        }
    }
    
    return esc_url($image);
}

//generate cutom excerpt
function centrino_post_excerpt($length){
    global $post;
    $uexcerpt = $post->post_excerpt?$post->post_excerpt:$post->post_content;
    $uexcerpt = strip_tags($uexcerpt);
    $uexcerpt = esc_html($uexcerpt);
    $excerpt = substr($uexcerpt,0,$length);
    $eexcerpt = substr($uexcerpt,$length);
    $excerpt .= array_shift(explode(" ",$eexcerpt));
    echo $excerpt?$excerpt.'...':$excerpt;
}

//generate cutom excerpt
function centrino_get_excerpt($post, $length){
    if(is_int($post)) $post = get_post($post);
    $uexcerpt = $post->post_excerpt?$post->post_excerpt:$post->post_content;
    $uexcerpt = strip_tags($uexcerpt);
    $uexcerpt = esc_html($uexcerpt);
    $excerpt = substr($uexcerpt,0,$length);
    $eexcerpt = substr($uexcerpt,$length);
    $excerpt .= array_shift(explode(" ",$eexcerpt));
    echo $excerpt?$excerpt.'...':$excerpt;
}



function centrino_meta_boxes(){
                                       
    $meta_boxes = array(
                        'multipurpose-icons'=>array('title'=>'Featured Icon','callback'=>'centrino_meta_box_icons','position'=>'side','priority'=>'core','post_type'=>'page'),
                        'multipurpose-page-excerpt'=>array('title'=>'Excerpt','callback'=>'centrino_meta_box_page_excerpt','position'=>'normal','priority'=>'core','post_type'=>'page'),
                        'multipurpose-post-settings'=>array('title'=>'Post Format Settings','callback'=>'centrino_meta_box_post_format_settings','position'=>'normal','priority'=>'core','post_type'=>'post'),
                   );
                       
                     
                       
    $meta_boxes = apply_filters("wpmp_meta_box", $meta_boxes);
    foreach($meta_boxes as $id=>$meta_box){
        extract($meta_box);
        add_meta_box($id, $title, $callback,$post_type, $position, $priority);
    }    
}

function centrino_meta_box_post_format_settings($post){
    $data = maybe_unserialize(get_post_meta($post->ID,'wpeden_post_meta', true));

    ?>
    <div class="pfset" id="post-format-link-settings">
        <label for="spro">Link URL</label><br/>
        <input type="text" style="width:370px" name="wpeden_post_meta[linkurl]" type="text" value="<?php echo isset($data['linkurl'])?$data['linkurl']:''; ?>" /><br/>
    </div>
    <div class="pfset" id="post-format-video-settings">
        <label for="spro">Video URL</label><br/>
        <input type="text" style="width:370px" id="spro" name="wpeden_post_meta[videourl]" type="text" value="<?php echo isset($data['videourl'])?$data['videourl']:''; ?>" /><br/>
    </div>
    <script>
        jQuery(function($){
            $('#post-formats-select input[type=radio]').click(function(){
                var id = '#'+this.id+'-settings'
                $('.pfset').hide();
                $(id).show();
            });
            $('.pfset').hide();
            $('#post-format-<?php echo get_post_format(); ?>-settings').show();
        });
    </script>
<?php
}

function centrino_meta_box_page_excerpt($post){
        $data = maybe_unserialize(get_post_meta($post->ID,'centrino_post_meta', true));
        if(!$data) $data['excerpt']  = '';
         
        ?>
        <textarea style="width: 100%" id="whyus" name="centrino_post_meta[excerpt]" type="text"><?php echo $data['excerpt']; ?></textarea>
        <?php     
}

function centrino_meta_box_icons(){
        global $post;

        $icons = array(
    "icon-glass",
    "icon-music",
    "icon-search",
    "icon-envelope",
    "icon-heart",
    "icon-star",
    "icon-star-empty",
    "icon-user",
    "icon-film",
    "icon-th-large",
    "icon-th",
    "icon-th-list",
    "icon-ok",
    "icon-remove",
    "icon-zoom-in",
    "icon-zoom-out",
    "icon-off",
    "icon-signal",
    "icon-cog",
    "icon-trash",
    "icon-home",
    "icon-file",
    "icon-time",
    "icon-road",
    "icon-download-alt",
    "icon-download",
    "icon-upload",
    "icon-inbox",
    "icon-play-circle",
    "icon-repeat",
    "icon-refresh",
    "icon-list-alt",
    "icon-lock",
    "icon-flag",
    "icon-headphones",
    "icon-volume-off",
    "icon-volume-down",
    "icon-volume-up",
    "icon-qrcode",
    "icon-barcode",
    "icon-tag",
    "icon-tags",
    "icon-book",
    "icon-bookmark",
    "icon-print",
    "icon-camera",
    "icon-font",
    "icon-bold",
    "icon-italic",
    "icon-text-height",
    "icon-text-width",
    "icon-align-left",
    "icon-align-center",
    "icon-align-right",
    "icon-align-justify",
    "icon-list",
    "icon-indent-left",
    "icon-indent-right",
    "icon-facetime-video",
    "icon-picture",
    "icon-pencil",
    "icon-map-marker",
    "icon-adjust",
    "icon-tint",
    "icon-edit",
    "icon-share",
    "icon-check",
    "icon-move",
    "icon-step-backward",
    "icon-fast-backward",
    "icon-backward",
    "icon-play",
    "icon-pause",
    "icon-stop",
    "icon-forward",
    "icon-fast-forward",
    "icon-step-forward",
    "icon-eject",
    "icon-chevron-left",
    "icon-chevron-right",
    "icon-plus-sign",
    "icon-minus-sign",
    "icon-remove-sign",
    "icon-ok-sign",
    "icon-question-sign",
    "icon-info-sign",
    "icon-screenshot",
    "icon-remove-circle",
    "icon-ok-circle",
    "icon-ban-circle",
    "icon-arrow-left",
    "icon-arrow-right",
    "icon-arrow-up",
    "icon-arrow-down",
    "icon-share-alt",
    "icon-resize-full",
    "icon-resize-small",
    "icon-plus",
    "icon-minus",
    "icon-asterisk",
    "icon-exclamation-sign",
    "icon-gift",
    "icon-leaf",
    "icon-fire",
    "icon-eye-open",
    "icon-eye-close",
    "icon-warning-sign",
    "icon-plane",
    "icon-calendar",
    "icon-random",
    "icon-comment",
    "icon-magnet",
    "icon-chevron-up",
    "icon-chevron-down",
    "icon-retweet",
    "icon-shopping-cart",
    "icon-folder-close",
    "icon-folder-open",
    "icon-resize-vertical",
    "icon-resize-horizontal",
    "icon-hdd",
    "icon-bullhorn",
    "icon-bell",
    "icon-certificate",
    "icon-thumbs-up",
    "icon-thumbs-down",
    "icon-hand-right",
    "icon-hand-left",
    "icon-hand-up",
    "icon-hand-down",
    "icon-circle-arrow-right",
    "icon-circle-arrow-left",
    "icon-circle-arrow-up",
    "icon-circle-arrow-down",
    "icon-globe",
    "icon-wrench",
    "icon-tasks",
    "icon-filter",
    "icon-briefcase",
    "icon-fullscreen",
);


        $data = maybe_unserialize(get_post_meta($post->ID,'centrino_post_meta', true));
        if(is_array($data))
        $icon = $data['icon'];
        ?>
        <label for="icons">Icon:</label>
        <select id="icons" name="centrino_post_meta[icon]" type="text">
        <?php foreach($icons  as $class ){ $name = ucwords(trim(str_replace(array('icon','-'),' ',$class))); echo "<option value='{$class}' ".selected($class, $icon).">{$name}</option>"; } ?>
        </select>
        <?php       
    
} 



function centrino_save_meta_data($postid, $post){
       if(isset($_POST['centrino_post_meta'])&&is_array($_POST['centrino_post_meta'])){
        update_post_meta($postid, 'centrino_post_meta',$_POST['centrino_post_meta']);
       }
}

function centrino_dynamic_thumb($path, $size){
    $name_p = explode(".",$path);
    $ext = ".".end($name_p);
    $thumbpath = str_replace($ext, "-".implode("x", $size).$ext, $path);
    if(file_exists($thumbpath)) return $thumbpath;
    $image = wp_get_image_editor( $path );
    if ( ! is_wp_error( $image ) ) {
        $image->resize( $size[0], $size[1], true );
        $image->save( $thumbpath );
    }
    return $thumbpath;
}

function centrino_post_gallery($w = 900, $h = 300, $post_id = null, $extra = array()){
    if(!$post_id) $post_id = get_the_ID();
    $n = 0;
    $attachments = get_posts( array(
        'post_type' => 'attachment',
        'posts_per_page' => -1,
        'post_parent' => $post_id
    ) );

    $html = "";
    $link = get_permalink($post_id);
    if ( $attachments ) {
        foreach ( $attachments as $attachment ) {
            $image = wp_get_attachment_image_src( $attachment->ID, 'full', true );
            $active = ($n++==0)?'active':'';
            $html .= "<div class='item {$active}'><a href='{$image[0]}' rel='image-preview-{$post_id}' class='imgpreview'><img src='".centrino_thumb_url($image[0], array($w, $h))."' /></a></div>";
        }

    }
    $uniqid = uniqid();
    echo '<div id="post-carousel-'.$post_id.'-'.$uniqid.'" class="carousel slide"><div class="carousel-inner">'.$html.'</div><a class="carousel-control left" href="#post-carousel-'.$post_id.'-'.$uniqid.'" data-slide="prev"><i class="icon icon-angle-left"></i></a><a class="carousel-control right" href="#post-carousel-'.$post_id.'-'.$uniqid.'" data-slide="next"><i class="icon icon-angle-right"></i></a></div>';
}

function centrino_gallery($params){
    $html = "";  
    $n = 0;

    if(isset($params['ids'])){
        $ids = explode(",",$params['ids']);
         
        $post_id = get_the_ID();
       
        foreach($ids as $id){
            $image = wp_get_attachment_image_src( $id, 'full', true );
            
            $active = ($n++==0)?'active':'';
            $html .= "<div class='item {$active}'><a href='{$image[0]}' rel='image-preview-{$post_id}' class='imgpreview'><img src='".centrino_thumb_url($image[0], array(900, 500))."' /></a></div>";
            
        }
    } else {
        if(!isset($post_id)) $post_id = get_the_ID();
        $attachments = get_posts( array(
            'post_type' => 'attachment',
            'posts_per_page' => -1,
            'post_parent' => $post_id
        ) );
        
        $link = get_permalink($post_id);
        if ( $attachments ) {
            foreach ( $attachments as $attachment ) {
                $image = wp_get_attachment_image_src( $attachment->ID, 'full', true );
                $active = ($n++==0)?'active':'';

                $html .= "<div class='item {$active}'><a href='{$image[0]}' rel='image-preview-{$post_id}' class='imgpreview'><img src='".centrino_thumb_url($image[0], array(900, 500))."' /></a></div>";
            }

        }
   }
    $uniqid = uniqid();
    return '<div id="post-carousel-'.$post_id.'-'.$uniqid.'" class="carousel slide"><div class="carousel-inner">'.$html.'</div><a class="carousel-control left" href="#post-carousel-'.$post_id.'-'.$uniqid.'" data-slide="prev"><i class="icon icon-angle-left"></i></a><a class="carousel-control right" href="#post-carousel-'.$post_id.'-'.$uniqid.'" data-slide="next"><i class="icon icon-angle-right"></i></a></div>';
    
}

//comments
function centrino_comment($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    $GLOBALS['comment'] = $comment;

    switch ( $comment->comment_type ) :
        case 'pingback' :
        case 'trackback' :
            ?>
            <li class="post pingback">
            <p>Pingback: <?php comment_author_link(); ?><?php edit_comment_link( 'Edit', '<span class="edit-link">', '</span>' ); ?></p>
            <?php
            break;
        default :
            ?>
                <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
                <div class="panel panel-default">

                    <div id="comment-<?php comment_ID(); ?>" class="clearfix media panel-body">
                        <div class="author-box pull-left">
                            <?php echo get_avatar($comment,100); ?>

                        </div> <!-- end .avatar-box -->
                        <div class="comment-wrap clearfix media-body">
                            <b><?php printf('<span class="fn">%s</span>', get_comment_author_link()) ?></b>

                            <div class="comment-content"><?php comment_text() ?></div> <!-- end comment-content-->

                        </div> <!-- end comment-wrap-->
                        <div class="comment-arrow"></div>
                    </div> <!-- end comment-body-->
                    <div class="panel-footer">
                        <?php if ($comment->comment_approved == '0') : ?>
                            <em class="moderation">Your comment is awaiting moderation.</em>

                        <?php endif; ?>
                        <a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>"><?php printf(  '<i class="fa fa-time"></i> %1$s at %2$s', get_comment_date(),  get_comment_time() ); ?></a>
                        <?php edit_comment_link( '<i class="fa fa-pencil"></i> Edit', ' ' ); ?>
                        <?php comment_reply_link(array_merge( $args, array('reply_text' => '<i class="fa fa-reply"></i> Reply','depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
                    </div>
                </div> <!-- end comment-body-->


            <?php
            break;
    endswitch;
}
 
 
 
//Sidebars
function centrino_widget_init(){
     
    register_sidebar(array(
      'name' => 'Header',
      'id' => 'header',
      'description' => 'Sidebar For Header.',
      'before_widget' => '<div class="panel panel-[#widget_style#]">',
      'after_widget' => '</div>',
      'before_title' => '<div class="panel-heading">',
      'after_title' => '</div>'
    ));
    register_sidebar(array(
      'name' => 'Product Page',
      'id' => 'product_page',
      'description' => 'Sidebar For Product Page.',
        'before_widget' => '<div class="panel panel-[#widget_style#]">',
        'after_widget' => '</div>',
        'before_title' => '<div class="panel-heading">',
        'after_title' => '</div>'
    ));
    register_sidebar(array(
      'name' => 'Author Page',
      'id' => 'author_page',
      'description' => 'Sidebar For Author Page.',
        'before_widget' => '<div class="panel panel-[#widget_style#]">',
        'after_widget' => '</div>',
        'before_title' => '<div class="panel-heading">',
        'after_title' => '</div>'
    ));
    register_sidebar(array(
      'name' => 'Single Post',
      'id' => 'single_post_sidebar',
      'description' => 'Sidebar For Single post.',
        'before_widget' => '<div class="panel panel-[#widget_style#]">',
        'after_widget' => '</div>',
        'before_title' => '<div class="panel-heading">',
        'after_title' => '</div>'
    ));

     register_sidebar(array(
      'name' => 'Homepage Right',
      'id' => 'homepage_sidebar_right',
      'description' => 'Right Sidebar For Homepage.',
         'before_widget' => '<div class="panel panel-[#widget_style#]">',
         'after_widget' => '</div>',
         'before_title' => '<div class="panel-heading">',
         'after_title' => '</div>'
    ));

     register_sidebar(array(
      'name' => 'Archive Page',
      'id' => 'archive_page_sidebar',
      'description' => 'Sidebar For Archive Page.',
         'before_widget' => '<div class="panel panel-[#widget_style#]">',
         'after_widget' => '</div>',
         'before_title' => '<div class="panel-heading">',
         'after_title' => '</div>'
    ));    
       
    
    register_sidebar(array(
      'name' => 'Footer Left',
      'id' => 'footer1',
      'description' => 'Footer Left',
        'before_widget' => '<div class="panel panel-[#widget_style#]">',
        'after_widget' => '</div>',
        'before_title' => '<div class="panel-heading">',
        'after_title' => '</div>'
    )); 
    
    register_sidebar(array(
      'name' => 'Footer Middle',
      'id' => 'footer2',
      'description' => 'Footer Middle',
        'before_widget' => '<div class="panel panel-[#widget_style#]">',
        'after_widget' => '</div>',
        'before_title' => '<div class="panel-heading">',
        'after_title' => '</div>'
    )); 
    
    register_sidebar(array(
      'name' => 'Footer Right',
      'id' => 'footer3',
      'description' => 'Footer Right',
        'before_widget' => '<div class="panel panel-[#widget_style#]">',
        'after_widget' => '</div>',
        'before_title' => '<div class="panel-heading">',
        'after_title' => '</div>'
    ));  
    register_sidebar(array(
      'name' => 'Footer Last',
      'id' => 'footer4',
      'description' => 'Footer Last',
        'before_widget' => '<div class="panel panel-[#widget_style#]">',
        'after_widget' => '</div>',
        'before_title' => '<div class="panel-heading">',
        'after_title' => '</div>'
    )); 
 }
 
// wp_title filter
function centrino_filter_wp_title( $old_title, $sep, $sep_location ){
    $ssep = ' ' . $sep . ' ';
    // find the type of index page this is
    if( is_category() ) $insert = $ssep . 'Category';
    elseif( is_tag() ) $insert = $ssep . 'Tag';
    elseif( is_author() ) $insert = $ssep . 'Author';
    elseif( is_year() || is_month() || is_day() ) $insert = $ssep . 'Archives';
    else $insert = NULL;
     
    // get the page number we're on (index)
    if( get_query_var( 'paged' ) )
    $num = $ssep . 'page ' . get_query_var( 'paged' );
     
    // get the page number we're on (multipage post)
    elseif( get_query_var( 'page' ) )
    $num = $ssep . 'page ' . get_query_var( 'page' );
     
    // else
    else $num = NULL;
    
    $site_description = get_bloginfo( 'description', 'display' );
    if ( is_home() && $site_description )
    $old_title .=  $ssep  . $site_description;
     
    // concoct and return new title
    return get_bloginfo( 'name' ) . $insert . $old_title . $num;
}
 
 
//Theme setup function 
function centrino_setup(){
    register_nav_menus( array(
        'primary' => 'Top Menu' 
          
    ) );
    
    
    add_theme_support( 'post-thumbnails' );
    //if(has_post_format('aside'))
    add_theme_support( 'post-formats', array( 'aside','image','chat', 'gallery','audio','video','quote','link' ) );
    add_post_type_support( 'post', 'post-formats' );
    add_theme_support("automatic-feed-links");
    add_theme_support("excerpt",array('post','page'));
    add_theme_support('custom-background');
     
    add_image_size( 'multipurpose-post-thumb', 960, 99999, false );
    add_image_size( 'multipurpose-blog-thumb', 960, 300, true ); 
    add_image_size( 'multipurpose-intro-thumb', 470, 200, true ); 
    add_image_size( 'multipurpose-category-thumb', 270, 270, true ); 
 
 }
 
 function centrino_enqueue_scripts(){
     wp_deregister_style('wpdm-bootstrap-theme');
    wp_enqueue_style('multipurpose-main',get_stylesheet_uri());
    wp_enqueue_style('eden-ui',get_template_directory_uri().'/css/eden.css', 99999999);
    wp_enqueue_style('multipurpose-less',get_template_directory_uri().'/css/style.less');
    wp_enqueue_style('multipurpose-slider-css2',get_template_directory_uri().'/css/slider/style2.css');

    wp_enqueue_script('multipurpose-less',get_template_directory_uri().'/js/less.js',array('jquery'));
    //wp_enqueue_script('multipurpose-bootstrap',get_template_directory_uri().'/bootstrap/js/bootstrap.min.js',array('jquery'));
    wp_enqueue_script('multipurpose-modernizr',get_template_directory_uri().'/js/modernizr.custom.28468.js',array('jquery'));
    wp_enqueue_script('multipurpose-cslider',get_template_directory_uri().'/js/jquery.cslider.js',array('jquery'));
    wp_enqueue_script('multipurpose-site',get_template_directory_uri().'/js/site.js',array('jquery'));
    wp_enqueue_style('font-awesome','//netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.min.css');
    wp_enqueue_script( 'comment-reply' );
 }

function centrino_enqueue_less_styles($tag, $handle) {
    global $wp_styles;
    $match_pattern = '/\.less$/U';
    if ( preg_match( $match_pattern, $wp_styles->registered[$handle]->src ) ) {
        $handle = $wp_styles->registered[$handle]->handle;
        $media = $wp_styles->registered[$handle]->args;
        $href = $wp_styles->registered[$handle]->src . '?ver=' . $wp_styles->registered[$handle]->ver;
        $rel = isset($wp_styles->registered[$handle]->extra['alt']) && $wp_styles->registered[$handle]->extra['alt'] ? 'alternate stylesheet' : 'stylesheet';
        $title = isset($wp_styles->registered[$handle]->extra['title']) ? "title='" . esc_attr( $wp_styles->registered[$handle]->extra['title'] ) . "'" : '';

        $tag = "<link rel='stylesheet' id='$handle' $title href='$href' type='text/less' media='$media' />";
    }
    return $tag;
}

function centrino_less_var(){
    ?>
    <script type="text/javascript">
        less.modifyVars({
            '@color': '<?php echo wpeden_get_theme_opts('color_scheme','#3399ff'); ?>'
        });
    </script>
    <?php
}

function crypton_recommend_author(){
    if(isset($_REQUEST['action'])&&$_REQUEST['action']=='__wpdm_rec'){
    global $current_user;
    if(!is_user_logged_in()||!isset($_REQUEST['author'])) die('error');
    $author = $_REQUEST['author'];
    $recommend = maybe_unserialize(get_user_meta($author, '__wpdm_recommend', true));
    if(isset($recommend[$current_user->ID])) unset($recommend[$current_user->ID]);
    else $recommend[$current_user->ID] = 1;
    update_user_meta($author, '__wpdm_recommend', $recommend);
    echo count($recommend);
    die();
    }
}

function crypton_comment_form_defaults( $defaults ) {

    $req      = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );
    $html5    = true; //'html5' === $defaults['format'];
    $commenter = wp_get_current_commenter();
    $user = wp_get_current_user();
    $user_identity = $user->exists() ? $user->display_name : '';
    $post_id = get_the_ID();

    $fields   =  array(
        'author' => '<p class="comment-form-author">' . '<label for="author">' . __( 'Name' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
            '<input id="author" class="form-control" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></p>',
        'email'  => '<p class="comment-form-email"><label for="email">' . __( 'Email' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
            '<input id="email" class="form-control" name="email" ' . ( $html5 ? 'type="email"' : 'type="text"' ) . ' value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-describedby="email-notes"' . $aria_req . ' /></p>',
        'url'    => '<p class="comment-form-url"><label for="url">' . __( 'Website' ) . '</label> ' .
            '<input id="url" class="form-control" name="url" ' . ( $html5 ? 'type="url"' : 'type="text"' ) . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></p>',
    );

    $required_text = sprintf( ' ' . __('Required fields are marked %s'), '<span class="required">*</span>' );

    $defaults = array(
        'fields'               => $fields,
        'comment_field'        => '<p class="comment-form-comment"><label for="comment">' . _x( 'Comment', 'noun' ) . '</label> <textarea id="comment" class="form-control" name="comment" cols="45" rows="8" aria-describedby="form-allowed-tags" aria-required="true"></textarea></p>',
        /** This filter is documented in wp-includes/link-template.php */
        'must_log_in'          => '<p class="must-log-in">' . sprintf( __( 'You must be <a href="%s">logged in</a> to post a comment.' ), wp_login_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
        /** This filter is documented in wp-includes/link-template.php */
        'logged_in_as'         => '<p class="logged-in-as">' . sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>' ), get_edit_user_link(), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
        'comment_notes_before' => '<p class="comment-notes"><span id="email-notes">' . __( 'Your email address will not be published.' ) . '</span>'. ( $req ? $required_text : '' ) . '</p>',
        'comment_notes_after'  => '<p class="form-allowed-tags" id="form-allowed-tags">' . sprintf( __( 'You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s' ), ' <code>' . allowed_tags() . '</code>' ) . '</p>',
        'id_form'              => 'commentform',
        'id_submit'            => 'submit',
        'class_submit'         => 'submit',
        'name_submit'          => 'submit',
        'title_reply'          => __( 'Leave a Reply' ),
        'title_reply_to'       => __( 'Leave a Reply to %s' ),
        'cancel_reply_link'    => __( 'Cancel reply' ),
        'label_submit'         => __( 'Post Comment' ),
        'format'               => 'xhtml',
    );


   return $defaults;


}

function crypton_author_recommends($author){
    $recommend = maybe_unserialize(get_user_meta($author, '__wpdm_recommend', true));
    return count($recommend);
}

add_action( 'wp_enqueue_scripts', 'centrino_enqueue_scripts');

add_filter( 'comment_form_defaults', 'crypton_comment_form_defaults');
add_filter( 'wp_title', 'centrino_filter_wp_title', 10, 3 );
add_action( 'widgets_init', 'centrino_widget_init' );
add_action( 'after_setup_theme', 'centrino_setup' );
add_action( 'admin_init', 'centrino_meta_boxes', 0 );
add_action( 'save_post', 'centrino_save_meta_data',10,2);
add_shortcode( 'gallery', 'centrino_gallery',9);
add_filter( 'style_loader_tag', 'centrino_enqueue_less_styles', 5, 2);
add_action('wp_head','centrino_less_var',99);
add_action('init','crypton_recommend_author',99);
