<?php
if ( ! defined( 'WPINC' ) ) {
    die;
}

class WpmpR_Sales{

    private static $instance;
    private $var,$currency;

    public static function getInstance() {
        if(self::$instance === null && $_REQUEST['page_now']=='sales') {
            self::$instance = new self;
            self::$instance->var = array();
            self::$instance->currency = get_option('_wpmp_curr_sign','$');
            self::$instance->actions();
        }
        return self::$instance;
    }

//    private function actions(){
//        //echo "hello World";
//        $this->menu();
//        if(isset($_REQUEST['sec'])=='by_day' || isset($_REQUEST['sec'])==''){
//            $this->salesByDay();
//        }
//        else if(isset($_REQUEST['sec'])=='by_month'){
//            $this->salesByMonth();
//        }
//        else if(isset($_REQUEST['sec'])=='product_sales'){
//            $this->productSales();
//        }
//
//
//    }

    private function actions() {
        $this->menu();

        $sec = isset($_REQUEST['sec']) ? $_REQUEST['sec'] : '';

        if ($sec == 'by_day' || $sec == '') {
            $this->salesByDay();
        } else if ($sec == 'by_month') {
            $this->salesByMonth();
        } else if ($sec == 'product_sales') {
            $this->productSales();
        }
    }



private function menu(){

        ?>
        <div class='dm-card rounded-none -mx-5 -mt-7'>
            <div class="dm-card-heading p-0">
            <ul class="grid grid-cols-3 items-center *:!m-0 *:text-center *:text-gray-500 *:border-r *:!border-r-gray-200">
                <li class="<?php echo (wpdm_query_var('sec') == 'by_day' || !wpdm_query_var('sec')) ? 'active bg-gray-200' : ''; ?>">
                    <a class='py-3 block' href="<?php echo admin_url('edit.php?post_type=wpdmpro&page=product-reports&page_now=sales&sec=by_day'); ?>">
                        <?= __('Sales By Day', 'wpdmpp-sales-report') ?>
                    </a>
                </li>
                <li class="<?php echo (wpdm_query_var('sec') == 'by_month') ? 'active bg-gray-200' : ''; ?>">
                    <a class='py-3 block' href="<?php echo admin_url('edit.php?post_type=wpdmpro&page=product-reports&page_now=sales&sec=by_month'); ?>">
                        <?= __('Sales By Month', 'wpdmpp-sales-report') ?>
                    </a>
                </li>
                <li class="<?php echo (wpdm_query_var('sec') == 'product_sales') ? 'active bg-gray-200' : ''; ?> !border-r-none">
                    <a class='py-3 block' href="<?php echo admin_url('edit.php?post_type=wpdmpro&page=product-reports&page_now=sales&sec=product_sales'); ?>">
                        <?= __('Product Sales', 'wpdmpp-sales-report') ?>
                    </a>
                </li>
            </ul>
</div>
        <?php
    }

    private function salesByDay(){

        ?>
        <div class='bg-gray-200 px-5 pt-6 pb-4 border-b -mt-px border-b-gray-300'>
            <form class='w-full xl:w-2/3' role="form" id="sales_form">
                <?php wp_nonce_field('wpmpr_sales_by_day'); ?>
                <input type="hidden" name="action" class='w-full' value="wpmpr_sales_by_day" />
                <div class='grid grid-cols-1 sm:grid-cols-3 gap-x-3 justify-center items-end *:mb-4 '>
                    <div>
                        <label class='pb-2 block' for="from"><?= __('From Date:','wpdmpp-sales-report')?> </label>
                        <input type="text" name='from' class="dm-input" id="from" readonly="readonly">
                    </div>
                    <div>
                        <label  class='pb-2 block' for="to"><?= __('To Date:','wpdmpp-sales-report')?> </label>
                        <input type="text" name='to' class="dm-input" id="to" readonly="readonly">
                    </div>
                    <button type="submit" class="dm-btn w-full" id="show"><?= __('Show','wpdmpp-sales-report')?> </button>
                </div>
            </form>
            <div id='error_div'></div>
        </div>

    <div class="dm-card-body p-0">
        <div class='px-5 pt-5 grid xl:grid-cols-5 gap-x-5' style="display:none;" id="graph_row">
            <div class='grid sm:grid-cols-3 xl:grid-cols-1 gap-x-5'>
                <div class="dm-card">
                    <div class="dm-card-heading"><?= __('Total Sales In Range','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body">
                        <h4 id="totalSales"></h4>
                    </div>
                </div>
                <div class="dm-card">
                    <div class="dm-card-heading"><?= __('Total Orders In Range','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body">
                        <h4 id="totalOrder"></h4>
                    </div>
                </div>
                <div class="dm-card">
                    <div class="dm-card-heading"><?= __('Total Product Count','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body">
                        <h4 id="productCount"></h4>
                    </div>
                </div>
            </div>
            <div class="dm-card xl:col-span-4">
                <div class="dm-card-heading"><?= __('Sales In Range','wpdmpp-sales-report')?> </div>
                <div class="dm-card-body py-2 pl-3 pr-0">
                    <div id="sales_graph_2"></div>
                </div>
            </div>
        </div>

        <script type="text/javascript">

            jQuery(function($) {
                $("#from").datepicker({ changeMonth: true, changeYear: true, yearRange: '1900:+0', maxDate:'+0', dateFormat:'yy-mm-dd' });
                $("#to").datepicker({ changeMonth: true, changeYear: true, yearRange: '1900:+0', maxDate:'+0', dateFormat:'yy-mm-dd' });

                $('#sales_form').submit(function() {
                    $(this).ajaxSubmit({
                        dataType: 'json',
                        url: '<?php echo admin_url('admin-ajax.php'); ?>',
                        success: function(res) {
                            console.log(res);

                            if (res.type === "success") {
                                var str = "";

                                if (res.error) {
                                    alert(3);
                                    $.each(res.error, function(key, val) {
                                        str += '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' + val + '</div>';
                                    });
                                    $('#error_div').html(str);
                                } else {
                                    $('#error_div').html('');
                                    $('#graph_row').fadeIn('slow');


                                    $('#totalSales').html('<?php echo $this->currency; ?>' + (res.total_income ? res.total_income : '0'));
                                    $('#totalOrder').html(res.total_order ? res.total_order : '0');
                                    $('#productCount').html(res.total_product ? res.total_product : '0');

                                    if(res.byDays){
                                        var byDays=[];
                                        $.each(res.byDays,function(key,val){
                                            byDays.push([key,val]);
                                        });
                                        jQuery.jqplot.config.enablePlugins = true;
                                        $('#sales_graph_2 div, #sales_graph_2 canvas').remove();
                                        plot2 = $.jqplot('sales_graph_2',[byDays], {
                                            title:'Sales By Days',
                                            animate: true,
                                            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
                                            seriesDefaults:{
                                                renderer:$.jqplot.BarRenderer,
                                                rendererOptions: {
                                                    // Set the varyBarColor option to true to use different colors for each bar.
                                                    // The default series colors are used.
                                                    varyBarColor: true
                                                }
                                            },
                                            axes:{
                                                xaxis:{
                                                    renderer: $.jqplot.CategoryAxisRenderer
                                                }
                                            }
                                        });
                                    }else {
                                        $('#sales_graph_2').html('No records found');
                                    }
                                }
                            } else {
                                alert('Something went wrong');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error(xhr.responseText);
                            alert('Error: ' + xhr.responseText);
                        }
                    });
                    return false;
                });
            });

        </script>

        <?php
    }

    private function salesByMonth(){

        ?>

        <div class='bg-gray-200 px-5 pt-6 pb-7 border-y -my-px border-gray-300'>
            <form class='w-full md:w-1/3' role="form" id="sales_form">
                <?php wp_nonce_field('wpmpr_sales_by_month'); ?>
                <input type="hidden" name="action" value="wpmpr_sales_by_month" />
                <div class='grid grid-cols-2 gap-x-3 justify-center items-end'>
                    <div>
                        <label class='pb-2 block' for="from"><?= __('Year:','wpdmpp-sales-report')?> </label>
                        <select name='year' id='year' class="dm-input">
                            <option value=""><?= __('Select a year','wpdmpp-sales-report')?> </option>
                                <?php
                                global $wpdb;
                                $sql = "SELECT MAX(`date`) as max, MIN(`date`) as min FROM `{$wpdb->prefix}ahm_orders`";
                                $row = $wpdb->get_row($sql,ARRAY_A);
                                if($row){
                                    $start = (int) date('Y',$row['min']);
                                    $end = (int) date('Y',$row['max']);
                                    for ($i = $start; $i<=$end; $i++) {
                                    echo "<option value='$i'>$i</option>";
                                    }
                                }
                                ?>
                        </select>
                    </div>
                    <button type="submit" class="dm-btn w-full" id="show"><?= __('Show','wpdmpp-sales-report')?> </button>
                </div>
            </form>
            <div id='error_div'></div>
        </div>


        <div class='px-5 pt-5 grid xl:grid-cols-5 gap-x-5' style="display:none;" id="graph_row">
            <div class='grid sm:grid-cols-3 xl:grid-cols-1 gap-x-5'>
                <div class="dm-card">
                    <div class="dm-card-heading"><?= __('Total Sales For Year','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body">
                        <h4 id="totalSales"></h4>
                    </div>
                </div>
                <div class="dm-card">
                    <div class="dm-card-heading"><?= __('Total Orders For Year','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body">
                        <h4 id="totalOrder"></h4>
                    </div>
                </div>
                <div class="dm-card">
                    <div class="dm-card-heading"><?= __('Total Product Count','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body">
                        <h4 id="productCount"></h4>
                    </div>
                </div>
            </div>
            <div class="dm-card xl:col-span-4">
                <div class="dm-card-heading"><?= __('Monthly Sales For Year','wpdmpp-sales-report')?> </div>
                <div class="dm-card-body py-2 pl-3 pr-0">
                    <div id="sales_graph_2"></div>
                </div>
            </div>
        </div>

        <script type="text/javascript">
            jQuery(function($){
                $('#sales_form').submit(function(){
                    $(this).ajaxSubmit({
                        dataType: 'json',
                        url:'<?php echo admin_url('admin-ajax.php'); ?>',
                        success: function(res){
                            console.log(res);
                            //res = json_encode(res);
                            if(res.type=="success"){
                                var str= "";

                                if(res.error){
                                $.each(res.error,function(key,val){
                                    str += '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+val+'</div>'
                                });
                                $('#error_div').html(str);
                                }
                                else {
                                    $('#error_div').html('');
                                    $('#graph_row').fadeIn('slow');


                                    if(res.total_income) {
                                        $('#totalSales').html('<?php echo $this->currency; ?>' + res.total_income);
                                    } else {
                                        $('#totalSales').html('<?php echo $this->currency; ?>' + '0');
                                    }

                                    if(res.total_order) {
                                        $('#totalOrder').html(res.total_order);
                                    } else {
                                        $('#totalOrder').html('0');
                                    }

                                    if(res.total_product){
                                        $('#productCount').html(res.total_product);
                                    } else {
                                        $('#productCount').html('0');
                                    }

                                    if(res.byMonth){
                                        var byMonth=[];
                                        $.each(res.byMonth,function(key,val){
                                            byMonth.push([key,val]);
                                        });
                                        jQuery.jqplot.config.enablePlugins = true;
                                        $('#sales_graph_2 div, #sales_graph_2 canvas').remove();

                                        var plot2 = $.jqplot('sales_graph_2',[byMonth], {
                                            title:'Sales By Month',
                                            animate: true,
                                            seriesDefaults:{
                                                renderer:$.jqplot.BarRenderer,
                                                rendererOptions: {
                                                    // Set the varyBarColor option to true to use different colors for each bar.
                                                    // The default series colors are used.
                                                    varyBarColor: true
                                                }
                                            },
                                            axes:{
                                                xaxis:{
                                                    renderer: $.jqplot.CategoryAxisRenderer
                                                }
                                            }
                                        });
                                    }
                                    else{
                                            $('#sales_graph_2').html('<h2><?= __('No Record found','wpdmpp-sales-report')?> </h2>');
                                    }
                                }

                            }
                            else {
                                alert('Something Went Wrong');
                            }
                        }
                    });
                    return false;
                });


            });

        </script>

        <?php
    }

    private function productSales(){

        ?>

        <div class='bg-gray-200 pl-5 pr-2.5 md:pr-5 pt-6 pb-4 border-b -mt-px border-b-gray-300'>
            <form role="form" id="sales_form">
                <?php wp_nonce_field('wpmpr_product_sales'); ?>
                <input type="hidden" name="action" value="wpmpr_product_sales" />
                <div class='grid grid-cols-1 sm:grid-cols-5 gap-x-3 justify-center items-end *:mb-4'>
                    <div>
                        <label class='pb-2 block'for="from"><?= __('From:','wpdmpp-sales-report')?> </label>
                        <input class="dm-input" typ='text' id='from' name='from' readonly="readonly">
                    </div>
                    <div>
                        <label class='pb-2 block'for="to"><?= __('To:','wpdmpp-sales-report')?> </label>
                        <input class="dm-input" type='text' id='to' name='to' readonly="readonly">
                    </div>
                    <div>
                        <label class='pb-2 block' for="ptitle"><?= __('Product:','wpdmpp-sales-report')?> </label>
                        <div x-data="{ modalOpen: false }" @keydown.escape.window="modalOpen = false"
                            class="relative w-auto h-auto">
                            <input @click="modalOpen=true" class="dm-input" type="text" id="lpid" placeholder="Product Name" data-toggle="modal" data-target="#product-src-modal" name="pid" value="<?php echo isset($coupon)?$coupon->product:''; ?>">
                            <!--<div class="input-group-btn"><button type="button" class="btn btn-default" data-toggle="modal" data-target="#product-src-modal"><i class="fas fa-search-plus"></i></button></div>-->
                            <template x-teleport="body">
                                <div x-show="modalOpen" class="fixed top-0 left-0 !z-[99999999999] flex items-center justify-center w-screen h-screen " x-cloak>
                                    <div x-show="modalOpen"
                                        x-transition:enter="ease-out duration-300"
                                        x-transition:enter-start="opacity-0"
                                        x-transition:enter-end="opacity-100"
                                        x-transition:leave="ease-in duration-300"
                                        x-transition:leave-start="opacity-100"
                                        x-transition:leave-end="opacity-0"
                                        @click="modalOpen=false" class="absolute inset-0 w-full h-full bg-black bg-opacity-40"></div>
                                    <div x-show="modalOpen"
                                        x-trap.inert.noscroll="modalOpen"
                                        x-transition:enter="ease-out duration-300"
                                        x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                                        x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                                        x-transition:leave="ease-in duration-200"
                                        x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                                        x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                                        class="relative w-full py-6 bg-white px-7 sm:max-w-lg sm:rounded-lg">
                                        <div class="flex items-center justify-between pb-2">
                                            <h3 class="text-lg font-semibold"><?php _e('Select Product','wpdm-premium-packages'); ?></h3>
                                            <button @click="modalOpen=false" class="absolute top-0 right-0 flex items-center justify-center w-8 h-8 mt-5 mr-5 text-gray-600 rounded-full hover:text-gray-800 hover:bg-gray-50">
                                                <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" /></svg>
                                            </button>
                                        </div>
                                        <div class="relative w-auto">
                                            <input class="dm-input" type="text" placeholder="<?php _e('Search Product...','wpdm-premium-packages'); ?>" id="srcp">
                                            <div @click="modalOpen=false" class="mt-3 bg-white border border-gray-300 rounded-lg divide-y divide-gray-200 *:px-4 *:py-2 *:text-gray-700" id="productlist"></div>
                                        </div>
                                    </div>
                                </div>
                            </template>
                        </div>

                    </div>
                    <div>
                        <label class='pb-2 block'for="view"><?= __('View:','wpdmpp-sales-report')?> </label>
                        <select class="dm-input !max-w-none" name="view" id="">
                            <option value="1"><?= __('By Days','wpdmpp-sales-report')?> </option>
                            <option value='2'><?= __('By Months','wpdmpp-sales-report')?> </option>
                        </select>
                    </div>
                    <button type="submit" class="dm-btn w-full" id="show"><?= __('Search','wpdmpp-sales-report')?> </button>
                </div>
            </form>
            <div id='error_div'></div>
        </div>

        <div class='px-5 pt-5' style="display:none;" id="graph_row">
            <div class='grid grid-cols-1 md:grid-cols-5 gap-x-5'>
                <div class="dm-card md:col-span-2 lg:col-auto">
                    <div class="dm-card-heading"><?= __('Total Sale','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body">
                        <h4 id="totalSales"></h4>
                    </div>
                </div>
                <div class="dm-card md:col-span-3 lg:col-span-4">
                    <div class="dm-card-heading"><?= __('Sales Graph','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body py-2 pl-3 pr-0">
                        <div id="sales_graph_1"></div>
                    </div>
                </div>
            </div>
            <div class='grid grid-cols-1 md:grid-cols-5 gap-x-5'>
                <div class="dm-card md:col-span-2 lg:col-auto">
                    <div class="dm-card-heading"><?= __('Product Count','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body">
                        <h4 id="totalOrder"></h4>
                    </div>
                </div>
                <div class="dm-card md:col-span-3 lg:col-span-4">
                    <div class="dm-card-heading"><?= __('Product Count Graph','wpdmpp-sales-report')?> </div>
                    <div class="dm-card-body py-2 pl-3 pr-0">
                        <div id="sales_graph_2"></div>
                    </div>
                </div>
            </div>
        </div>

<script type="text/javascript">
    jQuery(function($){
        $("#from").datepicker({ changeMonth: true, changeYear: true, yearRange: '1900:+0', maxDate:'+0', dateFormat:'yy-mm-dd' });
        $("#to").datepicker({ changeMonth: true, changeYear: true, yearRange: '1900:+0', maxDate:'+0', dateFormat:'yy-mm-dd' });


        $('#sales_form').submit(function(){
            $(this).ajaxSubmit({
                dataType: 'json',
                url:'<?php echo admin_url('admin-ajax.php'); ?>',
                success: function(res){
                    console.log(res);
                    // res = json_encode(res);
                    if(res.type=="success"){
                        var str= "";

                        if(res.error){
                            $.each(res.error,function(key,val){
                                str += '<div class="alert alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+val+'</div>'
                            });
                            $('#error_div').html(str);
                        }
                        else {
                            $('#error_div').html('');
                            $('#graph_row').fadeIn('slow');

                            if(res.totalAmount) {
                                $('#totalSales').html('<?php echo $this->currency; ?>' + res.totalAmount.toFixed(2));
                            } else {
                                $('#totalSales').html('<?php echo $this->currency; ?>' + '0');
                            }

                            if(res.totalCount) {
                                $('#totalOrder').html(res.totalCount);
                            } else {
                                $('#totalOrder').html('0');
                            }

                            if(res.productTotal){
                                var productTotal=[];
                                $.each(res.productTotal,function(key,val){
                                    productTotal.push([key,val]);
                                });
                                jQuery.jqplot.config.enablePlugins = true;
                                $('#sales_graph_1 div, #sales_graph_1 canvas').remove();

                                var plot1 = $.jqplot('sales_graph_1',[productTotal], {
                                    title:'Sales Graph',
                                    animate: true,
                                    grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
                                    seriesDefaults:{
                                        renderer:$.jqplot.BarRenderer,
                                        rendererOptions: {
                                            // Set the varyBarColor option to true to use different colors for each bar.
                                            // The default series colors are used.
                                            varyBarColor: true
                                        }
                                    },
                                    axes:{
                                        xaxis:{
                                            renderer: $.jqplot.CategoryAxisRenderer
                                        }
                                    }
                                });
                            }
                            else{
                                $('#sales_graph_1').html('<h2><?= __('No Record found','wpdmpp-sales-report')?> </h2>');
                            }


                            if(res.productCount){
                                var productCount=[];
                                $.each(res.productCount,function(key,val){
                                    productCount.push([key,val]);
                                });
                                jQuery.jqplot.config.enablePlugins = true;
                                $('#sales_graph_2 div, #sales_graph_2 canvas').remove();

                                var plot2 = $.jqplot('sales_graph_2',[productCount], {
                                    title:'Product Count Graph',
                                    animate: true,
                                    grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
                                    seriesDefaults:{
                                        //renderer:$.jqplot.BarRenderer,
                                        rendererOptions: {
                                            // Set the varyBarColor option to true to use different colors for each bar.
                                            // The default series colors are used.
                                            varyBarColor: true
                                        }
                                    },
                                    axes:{
                                        xaxis:{
                                            renderer: $.jqplot.CategoryAxisRenderer
                                        }
                                    }
                                });
                            }
                            else{
                                $('#sales_graph_2').html('<h2><?= __('No Record found','wpdmpp-sales-report')?> </h2>');
                            }


                        }

                    }
                    else {
                        alert('Something Went Wrong');
                    }
                }
            });
            return false;
        });

        function search_product()
        {
            $.get('<?= wpdm_rest_url('search') ?>', { search: $('#srcp').val(), premium: 1 }, function (res) {

                $('#productlist').html("");

                $(res.packages).each(function( i, package ) {
                    var licenses = package.licenses;
                    $("#productlist").append("<div class=''><a  href='#' data-pid='" + package.ID + "' data-index='" + i + "' class='pull-right wpdm-insert-pid'><i class='fa fa-plus-circle color-green inline-block float-right text-lg -mr-1 -mt-1 text-green-500'></i></a>" + package.post_title + "</div>");
                });
            });
        }

        $('body').on('keyup', '#srcp', function () {
            search_product();
        });

        $('body').on('click', '.wpdm-insert-pid', function (e) {
            e.preventDefault();
            $('#lpid').val($(this).data('pid'));
            $('#product-src-modal').modal('hide');
        });

    });

</script>

        <?php
    }

    private function salesByCategory(){
        ?>
        <div class="row">
            <div class="col-md-12">
                <form class="form-inline" role="form">
                    <div class="form-group">
                        <label class="" for="from"><?= __('From Date:','wpdmpp-sales-report')?> </label>
                        <input type="text" class="form-control" id="from" readonly="readonly">
                    </div>
                    <div class="form-group">
                        <label class="" for="to"><?= __('To Date:','wpdmpp-sales-report')?> </label>
                        <input type="text" class="form-control" id="to" readonly="readonly">
                    </div>
                    <button type="submit" class="btn btn-danger"><?= __('Show','wpdmpp-sales-report')?> </button>
                </form>
            </div>
        </div>
        <div class="grid sm:grid-cols-4 gap-x-5">
            <div class="dm-card">
                <div class="dm-card-heading"><?= __('Total Sales In Range','wpdmpp-sales-report')?> </div>
                <div class="dm-card-body">
                    <h4><?php //echo $this->var['total_products']; ?></h4>
                </div>
            </div>

            <div class="dm-card">
                <div class="dm-card-heading"><?= __('Total Orders In Range','wpdmpp-sales-report')?> </div>
                <div class="dm-card-body">
                    <h4><?php //echo $this->var['total_products']; ?></h4>
                </div>
            </div>

            <div class="dm-card">
                <div class="dm-card-heading"><?= __('Total Product Count','wpdmpp-sales-report')?> </div>
                <div class="dm-card-body">
                    <h4><?php //echo $this->var['total_products']; ?></h4>
                </div>
            </div>
            <div class="dm-card">
                <div class="dm-card-heading"><?= __('Sales In Range','wpdmpp-sales-report')?> </div>
                <div class="dm-card-body">
                    <div id="sales_graph"><?= __('Hello','wpdmpp-sales-report')?> </div>
                </div>
            </div>
        </div>

    </div>
</div>
        <?php
    }



}
