<?php
if ( ! defined( 'WPINC' ) ) {
    die;
}

class WpmpR_Overview{
    private static $instance;
    private $var,$currency;
    public static function getInstance() {
        if(self::$instance === null) {
            self::$instance = new self;
            self::$instance->var = array();
            self::$instance->currency = get_option('_wpmp_curr_sign','$');
            self::$instance->actions();

        }
        return self::$instance;
    }

    private function actions(){
        $this->calculateStatics();
        $this->calculateCoupons();
        $this->overviewDivs();
        $this->mainDivs();
        $this->otherDivs();
    }

    private function calculateStatics(){
        global $wpdb;
        $wpdb->show_errors();
        //calculate total order count
        $this->var['total_orders'] = 0;
        $sql = "SELECT count(*) FROM `{$wpdb->prefix}ahm_orders` WHERE 1";
        $this->var['total_orders'] = $wpdb->get_var($sql);

        //calculate total coupon amount
        $this->var['total_coupon_amount'] =0;
        $sql="SELECT SUM(coupon_discount) FROM `{$wpdb->prefix}ahm_orders` ";
        $this->var['total_coupon_amount'] = $wpdb->get_var($sql);
        //calculate total sale
        $this->var['total_sales'] = 0;
        $sql = "SELECT sum(total) FROM `{$wpdb->prefix}ahm_orders` WHERE payment_status='Completed'";
        $this->var['total_sales'] = $wpdb->get_var($sql);

        //calculate total products
        $this->var['total_products'] = 0;
//        $sql = "SELECT count(*) FROM `{$wpdb->prefix}posts` WHERE `post_status`='publish' and `post_type`='wpmarketplace'";
        $sql = "SELECT COUNT(DISTINCT pid) FROM `{$wpdb->prefix}ahm_order_items` ";
        $this->var['total_products'] = $wpdb->get_var($sql);

        //calculate total categories
        $this->var['total_categories'] = 0;
        $this->var['total_categories'] = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->term_taxonomy WHERE taxonomy = 'ptype'");

        //total user
        $this->var['total_customer'] = 0;
        $sql = "SELECT count(*) FROM `{$wpdb->prefix}users`";
        $this->var['total_customer'] = $wpdb->get_var($sql);

        //$wpdb->show_errors();
        //$wpdb->print_error();

        //todays
        date_default_timezone_set('UTC');
        $yesterdays = strtotime(date('Y-m-d'));
        $date = date("Y-m-d H:i:s", $yesterdays);

        //total coupons count
        $this->var['totoal_coupons'] = 0;
        $sql = "SELECT COUNT(code) FROM `{$wpdb->prefix}ahm_coupons`";
        $this->var['total_coupons'] = $wpdb->get_var($sql);


        //todays total coupon count
        $this->var['total_coupon_count_t'] =0;
        $sql = "SELECT COUNT(*) FROM `{$wpdb->prefix}ahm_orders` WHERE DATE(FROM_UNIXTIME(date)) = CURDATE() AND `coupon_discount` > 0; ";
        $this->var['total_coupon_count_t'] = $wpdb->get_var($sql);

        //total orders
        $this->var['total_orders_t'] = 0;
        $sql = "SELECT count(*) FROM `{$wpdb->prefix}ahm_orders` WHERE date>=$yesterdays";
        $this->var['total_orders_t'] = $wpdb->get_var($sql);

        //total sale
        $this->var['total_sales_t'] = 0;
        $sql = "SELECT sum(total) FROM `{$wpdb->prefix}ahm_orders` WHERE payment_status='Completed' and date>='$yesterdays'";
        $this->var['total_sales_t'] = $wpdb->get_var($sql);

        //total_coupon_amount
        $this->var['total_coupon_amount_t']=0;
        $sql = "SELECT SUM(coupon_discount) FROM `{$wpdb->prefix}ahm_orders` WHERE DATE(FROM_UNIXTIME(date)) = CURDATE(); ";
        $this->var['total_coupon_amount_t'] = $wpdb->get_var($sql);

        //new customer
        $this->var['total_customer_t'] = 0;
        $sql = "SELECT count(*) FROM `{$wpdb->prefix}users` WHERE `user_registered` >= '$date'";
        $this->var['total_customer_t'] = $wpdb->get_var($sql);


        //check top 5

        //top 5 customer
        $this->var['top_customers'] = array();
        $sql = "SELECT uid, count(*) as cnt, sum(total) as total FROM `{$wpdb->prefix}ahm_orders` group by uid limit 5";
        $this->var['top_customers'] = $wpdb->get_results($sql,ARRAY_A);



        //top 5 products
        $this->var['top_products'] = array();
        $sql = "SELECT pid,sum(quantity) as sum  FROM `{$wpdb->prefix}ahm_order_items` group by pid order by sum desc limit 5";
        $results = $wpdb->get_results($sql,ARRAY_A);
        if($results){
            foreach ($results as $row):
            $this->var['top_products'][$row['pid']] = array(
                'title' => get_the_title($row['pid']),
                'amount' => $row['sum']
            );
            endforeach;
        }


        //top 5 payment method
        $this->var['top_payment_methods'] = array();
        $sql = "SELECT `payment_method`,count(*) as cnt, sum(total) as total FROM `{$wpdb->prefix}ahm_orders` group by `payment_method` order by total desc limit 5";
        $this->var['top_payment_methods'] = $wpdb->get_results($sql,ARRAY_A);

        //top 5 coupons
        $this->var['top_coupons'] = array();
        $sql= "SELECT coupon_code, SUM(coupon_discount) AS amount
FROM {$wpdb->prefix}ahm_orders
WHERE coupon_discount > 0
GROUP BY coupon_code
ORDER BY amount DESC
LIMIT 5";

        $results = $wpdb->get_results($sql,ARRAY_A);
        if($results){
            foreach ($results as $row):
                $this->var['top_coupons'][$row['coupon_code']] = array(
                    'coupon' => $row['coupon_code'],
                    'amount' => $row['amount']
                );
            endforeach;
        }

        //count order status
        $this->var['order_status'] = array();
        $sql = "SELECT `payment_status`,count(*) as cnt, sum(total) as total FROM `{$wpdb->prefix}ahm_orders` group by `payment_status` order by total desc";
        $this->var['order_status'] = $wpdb->get_results($sql,ARRAY_A);



        /////////main div content/////////////////////////
        //$now = date()
        $now = date('Y-m',strtotime('-1 year'));
        $now .= '-01';
        $month = strtotime($now);
        $month = strtotime('next month', $month);
        //by month sql quries
        $this->var['bymonth'] = array();
        for ($i = 1; $i <= 12; $i++) {
            $month2 = strtotime('next month', $month);
            $sql = "SELECT sum(total) FROM `{$wpdb->prefix}ahm_orders` WHERE `date` >= $month and `date` < $month2 and `payment_status`='Completed'";
            //echo $sql . '<br>';
            $idx = date('M-y',$month);
            $this->var['bymonth'][$idx] = $wpdb->get_var($sql);
            //$wpdb->print_error();

            $month = $month2;
        }


        //by day sql queries
        $this->var['byDays'] = array();
        $lastMonth = strtotime(date('Y-m-d',strtotime('last month')));
        $tmp = strtotime('+1 day',$lastMonth);
        $today = strtotime(date('Y-m-d'));
        while($tmp<=$today){
            $idx = date('M d',$tmp);
            $this->var['byDays'][$idx] = 0;
            $tmp = strtotime('+1 day', $tmp);
        }

        $sql = "SELECT date,total FROM `{$wpdb->prefix}ahm_orders` WHERE `date`>=$lastMonth and `payment_status`='Completed'";

        $results = $wpdb->get_results($sql, ARRAY_A);
        //$wpdb->print_error();
        if($results) {
            foreach ($results as $row):
                $day = date('M d',$row['date']);
                $this->var['byDays'][$day] += $row['total'];
            endforeach;


        }

        //by week
        $this->var['byWeeks'] = array();
        $lastWeek = strtotime(date('Y-m-d',strtotime('-1 week')));
        $temp = $lastWeek;
        for($i = 1; $i <= 7; $i++) {
            $idx = date('D', $temp);
            $this->var['byWeeks'][$idx] = 0;
            $temp = strtotime('next day',$temp);
        }
        $sql = "SELECT date,total FROM `{$wpdb->prefix}ahm_orders` WHERE `date`>=$lastWeek and `payment_status`='Completed'";

        $results = $wpdb->get_results($sql,ARRAY_A);
        //$wpdb->print_error();
        if($results){
            foreach($results as $row):
                $idx = date('D',$row['date']);
                $this->var['byWeeks'][$idx] += $row['total'];
            endforeach;
        }


    }

//    private function calculateCoupons(){
//        global $wpdb;
//        $copuons = array();
//        $this->var['total_coupon_amount'] = 0;
//        $this->var['total_coupon'] = 0;
//        $this->var['total_coupon_amount_t'] = 0;
//        $this->var['total_coupon_t'] = 0;
//        date_default_timezone_set('UTC');
//        $yesterdays = strtotime("-1 days");
//
//
//        //all coupons count
//        $sql = "SELECT `cart_data`,`date` FROM `{$wpdb->prefix}ahm_orders` WHERE 1";
//        $results = $wpdb->get_results($sql, ARRAY_A);
////        wpdmdd($results);
//        if ($results) {
//            foreach($results as $row):
//                $cart_data = maybe_unserialize($row['cart_data']);
//                    if(is_array($cart_data)):
//                    foreach($cart_data as $pid => $data):
//                        if(isset($data['coupon']) && trim($data['coupon']) != ''):
//                            if(isset($data['item']) && is_array($data['item'])) {
//                                foreach($data['item'] as $key => $item):
//                                    if(isset($copuons[$pid][$data['coupon']])) {
//                                        $copuons[$pid][$data['coupon']] += $item['coupon_amount'];
//                                        $this->var['total_coupon_amount'] += $item['coupon_amount'];
//
//                                        //today check
//                                        if(strtotime($row['date']) >= $yesterdays) {
//                                            $this->var['total_coupon_amount_t'] += $item['coupon_amount'];
//                                        }
//                                    }
//                                    else {
//                                        $copuons[$pid][$data['coupon']] = $item['coupon_amount'];
//                                        $this->var['total_coupon_amount'] += $item['coupon_amount'];
//                                        $this->var['total_coupon']++;
//
//                                        //today check
//                                        if(strtotime($row['date']) >= $yesterdays) {
//                                            $this->var['total_coupon_amount_t'] += $item['coupon_amount'];
//                                            $this->var['total_coupon_t']++;
//
//                                        }
//                                    }
//                                endforeach;
//                            }
//                        else {
//                            if(isset($copuons[$pid][$data['coupon']])) {
//                                $copuons[$pid][$data['coupon']] += $data['coupon_amount'];
//                                $this->var['total_coupon_amount'] += $data['coupon_amount'];
//
//                                //check for today
//                                if(strtotime($row['data']) >= $yesterdays){
//                                    $this->var['total_coupon_amount_t'] += $data['coupon_amount'];
//                                }
//                            }
//                            else {
//                                $copuons[$pid][$data['coupon']] = $data['coupon_amount'];
//                                $this->var['total_coupon_amount'] += $data['coupon_amount'];
//                                $this->var['total_coupon']++;
//
//                                //check for today
//                                if(strtotime($row['data']) >= $yesterdays){
//                                    $this->var['total_coupon_amount_t'] += $data['coupon_amount'];
//                                    $this->var['total_coupon_t']++;
//                                }
//                            }
//                        }
//                endif;
//            endforeach;
//                    endif;
//        endforeach;
//        }
//
//        //echo "</pre>";
//        $this->var['coupons'] = $copuons;
////        echo "<pre>"; print_r($this->var['coupons']); echo "</pre>";
//
//    }

    private function calculateCoupons() {
//        global $wpdb;
//        $copuons = array();
//        $this->var['total_coupon_amount'] = 0;
//        $this->var['total_coupon'] = 0;
//        $this->var['total_coupon_amount_t'] = 0;
//        $this->var['total_coupon_t'] = 0;
//        date_default_timezone_set('UTC');
//        $yesterday = strtotime("-1 days");
//
//        // Select coupon_code and coupon_discount from ahm_orders
//        $sql = "SELECT coupon_code, coupon_discount, date FROM {$wpdb->prefix}ahm_orders WHERE 1";
//        $results = $wpdb->get_results($sql, ARRAY_A);
////        wpdmdd($results);
//        if ($results) {
//            foreach ($results as $row) {
//                $coupon_code = $row['coupon_code'];
//                $coupon_discount = floatval($row['coupon_discount']);
//
//                // Increment total_coupon_amount for all orders
//                $this->var['total_coupon_amount'] += $coupon_discount;
//
//                // Increment total_coupon_amount_t and total_coupon_t for orders from yesterday
//                if (strtotime($row['date']) >= $yesterday) {
//                    $this->var['total_coupon_amount_t'] += $coupon_discount;
//                    $this->var['total_coupon_t']++;
//                }
//
//                // Track individual coupons and their amounts
//                if (!isset($copuons[$coupon_code])) {
//                    $copuons[$coupon_code] = $coupon_discount;
//                    $this->var['total_coupon']++;
//                } else {
//                    $copuons[$coupon_code] += $coupon_discount;
//                }
//            }
//        }
//
//        $this->var['coupons'] = $copuons;
    }


    private function overviewDivs(){
        ?>
<div class="grid sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-x-5 mb-2">
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Total Orders Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->var['total_orders']; ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Total Sales Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->currency . number_format($this->var['total_sales'],2,".",""); ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Total Customer Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->var['total_customer']; ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Total Products Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->var['total_products']; ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Total Categories Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->var['total_categories']; ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Total Coupons Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->var['total_coupons']; ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Total Coupons Amount','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo number_format($this->var['total_coupon_amount'],2,".",""); ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Today\'s Total Order Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo isset($this->var['total_orders_t']) && $this->var['total_orders_t'] !='' ? number_format($this->var['total_orders_t'], 0, ".", "") : '0'; ?></h4>
            </div>

        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Todays Total Sale','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->var['total_sales_t'] !='' ? number_format($this->var['total_sales_t'],2,".","") : '0'; ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Today\'s New Customer Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->var['total_customer_t']; ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Todays Total Coupon Count','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo $this->var['total_coupon_count_t']; ?></h4>
            </div>
        </div>
        <div class="dm-card">
            <div class="dm-card-heading"><?= __('Todays Total Coupon Amount','wpdmpp-sales-report')?> </div>
            <div class="dm-card-body">
                <h4 class='font-semibold'><?php echo  $this->var['total_coupon_amount_t'] !='' ? number_format($this->var['total_coupon_amount_t'],2,".","") : '0'; ?></h4>
            </div>
        </div>

</div>

    <?php
    }

    private function mainDivs(){

        ?>
            <div class="grid grid-cols-1 gap-x-5 mb-2">
                <div class="col-sm-12 col-md-12">
                    <div class="dm-card relative">
                        <div class="dm-card-heading" id="maindiv_heading"><?= __('Sales By Months','wpdmpp-sales-report')?> </div>
                        <div class="dm-card-body pl-3 pt-0 pb-2 pr-1">
                            <ul class="inline-flex gap-x-1.5 items-center mr-3 absolute right-0 top-1.5 pb-1.5 z-50">
                                <li class="leading-7 pb-1.5 -mt-[2px] active"><a href="#" class="change_graph" for="byMonths"><?= __('Sales For Last Year','wpdmpp-sales-report')?> </a></li>
                                <li class='leading-7 pb-1.5 -mt-[2px] has-[active]:text-2xl'><a href="#" class="change_graph" for="byDays"><?= __('Sales For Last Month','wpdmpp-sales-report')?> </a></li>
                                <li class='leading-7 pb-1.5 -mt-[2px]'><a href="#" class="change_graph" for="byWeeks"><?= __('Sales For Last Week','wpdmpp-sales-report')?> </a></li>
                                <li class='leading-7 pb-1.5 -mt-[2px]'><a href="#" class="change_graph" for="topProd"><?= __('Top Products','wpdmpp-sales-report')?> </a></li>
                            </ul>

                            <div>
                                <div id="byMonths" class="graph_main"></div>
                                <div id="byDays" class="graph_main" style="display: none;"></div>
                                <div id="byWeeks" class="graph_main"  style="display: none;"></div>
                                <div id="topProd" class="graph_main -mb-5 -ml-2"  style="display: none;"></div>
                            </div>

                            <script type="text/javascript">
                            /////Graph by Month/////////////
                            function byMonths(){
                                var byMonth = [<?php
                                    if(isset($this->var['bymonth'])){
                                        $cnt = count($this->var['bymonth']);
                                        $i = 1;
                                        foreach ($this->var['bymonth'] as $key => $val):
                                            if($val == "") $val = 0;
                                            //$val = intval($val);
                                            echo "['$key',$val]";
                                            if($i<$cnt) echo ', ';
                                            $i++;
                                        endforeach;
                                    }
                                ?>];
                                jQuery.jqplot.config.enablePlugins = true;
                                plot1 = jQuery.jqplot("byMonths",[byMonth], {
                                        grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
                                        animate: true,
                                        seriesDefaults:{
                                            renderer:jQuery.jqplot.BarRenderer,
                                            rendererOptions: {
                                                // Set the varyBarColor option to true to use different colors for each bar.
                                                // The default series colors are used.
                                                varyBarColor: true
                                            }
                                        },
                                        axes:{
                                            xaxis:{
                                                renderer: jQuery.jqplot.CategoryAxisRenderer
                                            }
                                        }
                                    });
                            }

                            /////Graph by Days/////////////
                            function byDays(){
                                var byDays = [<?php
                                    if(isset($this->var['byDays'])){
                                        $cnt = count($this->var['byDays']);
                                        $i = 1;
                                        foreach ($this->var['byDays'] as $key => $val):
                                            if($val == "") $val = 0;
                                            //$val = intval($val);
                                            echo "['$key',$val]";
                                            if($i<$cnt) echo ', ';
                                            $i++;
                                        endforeach;
                                    }
                                ?>];
                                jQuery.jqplot.config.enablePlugins = true;
                                plot2 = jQuery.jqplot("byDays",[byDays], {
                                    //title:'Sales By Days',
                                    animate: true,
                                    grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
                                    seriesDefaults:{
                                        //renderer:$.jqplot.BarRenderer,
                                        rendererOptions: {
                                            // Set the varyBarColor option to true to use different colors for each bar.
                                            // The default series colors are used.
                                            varyBarColor: true
                                        }
                                    },
                                    axes:{
                                        xaxis:{
                                            renderer: jQuery.jqplot.CategoryAxisRenderer
                                        }
                                    }
                                });
                            }

                            /////Graph by Weeks/////////////
                            function byWeeks(){
                                var weeks = [<?php
                                    if(isset($this->var['byWeeks'])){
                                        $cnt = count($this->var['byWeeks']);
                                        $i = 1;
                                        foreach ($this->var['byWeeks'] as $key => $val):
                                            if($val == "") $val = 0;
                                            //$val = intval($val);
                                            echo "['$key',$val]";
                                            if($i<$cnt) echo ', ';
                                            $i++;
                                        endforeach;
                                    }
                                ?>];
                                jQuery.jqplot.config.enablePlugins = true;
                                plot2 = jQuery.jqplot("byWeeks",[weeks], {
                                    //title:'Sales By Week',
                                    animate: true,
                                    grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
                                    seriesDefaults:{
                                        //renderer:jQuery.jqplot.BarRenderer,
                                        rendererOptions: {
                                            // Set the varyBarColor option to true to use different colors for each bar.
                                            // The default series colors are used.
                                            varyBarColor: true
                                        }
                                    },
                                    axes:{
                                        xaxis:{
                                            renderer: jQuery.jqplot.CategoryAxisRenderer
                                        }
                                    }
                                });
                            }

                            /////Graph Top Products/////////////
                            function topProd(){
                                var topProd = [<?php
                                    if(isset($this->var['top_products'])){
                                        $cnt = count($this->var['top_products']);
                                        $i = 1;
                                        foreach ($this->var['top_products'] as $key => $val):
                                            if($val == "") $val = 0;
                                            //$val = intval($val);
                                            echo "['{$val['title']}',{$val['amount']}]";
                                            if($i<$cnt) echo ', ';
                                            $i++;
                                        endforeach;
                                    }
                                ?>];
                                //jQuery.jqplot.config.enablePlugins = true;
                                plot2 = jQuery.jqplot("topProd",[topProd], {
                                    //title:'Top Products',
                                    animate: true,
                                    grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
                                    seriesDefaults:{
                                        renderer: jQuery.jqplot.PieRenderer,
                                        rendererOptions: {
                                            showDataLabels: true
                                        }
                                    },
                                    legend:{ show:true }
                                });
                            }

                                jQuery(function($){
                                    $('.change_graph').click(function(){
                                        $('.graph_main').hide();
                                        var id = $(this).attr('for');
                                        $('#'+id).fadeIn();
                                        //alert(id);
                                        var fn = window[id];
                                        // is object a function?
                                        if (typeof fn === "function") fn();

                                        $(this).parent().parent().find('li.active').removeClass('active');
                                        $(this).parent().addClass('active');
                                        $('#maindiv_heading').html($(this).html());
                                        return false;
                                    });

                                    byMonths();

                                });

                            </script>

                        </div>
                    </div>
                </div>
            </div>
        <?php
    }

    private function otherDivs(){

        ?>
<div class="grid md:grid-cols-2 gap-x-5 mb-2">
    <?php $this->orderSummary(); ?>
    <?php $this->orderStatus(); ?>
    <?php $this->topProducts(); ?>
    <?php $this->topPaymentMethods(); ?>
</div>

<div class="grid mb-2">
    <?php $this->recentOrders(); ?>
</div>


<div class="grid md:grid-cols-2 gap-x-5 mb-2">
    <?php $this->topCustomer(); ?>
    <?php $this->topCoupons(); ?>
</div>
        <?php


    }

    private function orderSummary(){
        global $wpdb;

        $yesterday = strtotime(date('Y-m-d',strtotime('-1 day')));
        $today = strtotime(date('Y-m-d'));
        $sql = "SELECT count(*) as cnt, sum(total) as total FROM `{$wpdb->prefix}ahm_orders` WHERE `date`>=$yesterday and `date`<$today and `payment_status`='Completed'";
        $yesterday = $wpdb->get_row($sql,ARRAY_A);


        $week = strtotime(date('Y-m-d',strtotime('-1 week')));
        $sql = "SELECT count(*) as cnt, sum(total) as total FROM `{$wpdb->prefix}ahm_orders` WHERE `date`>=$week and `payment_status`='Completed'";
        $lastWeek = $wpdb->get_row($sql,ARRAY_A);

        $month = strtotime(date('Y-m-d',  strtotime('-1 month')));
        $sql = "SELECT count(*) as cnt, sum(total) as total FROM `{$wpdb->prefix}ahm_orders` WHERE `date`>=$week and `payment_status`='Completed'";
        $lastMonth = $wpdb->get_row($sql,ARRAY_A);

        $year = strtotime(date('Y-m-d',  strtotime('-1 year')));
        $sql = "SELECT count(*) as cnt, sum(total) as total FROM `{$wpdb->prefix}ahm_orders` WHERE `date`>=$year and `payment_status`='Completed'";
        $lastYear = $wpdb->get_row($sql,ARRAY_A);

        ?>
<div class="dm-card">
  <div class="dm-card-heading"><?= __('Order Summary','wpdmpp-sales-report')?> </div>
  <div class="dm-card-body p-0">
      <table class="table table-bordered table-striped">
          <thead>
              <tr>
                  <th><?= __('Sales Order','wpdmpp-sales-report')?> </th>
                  <th><?= __('Order Count','wpdmpp-sales-report')?> </th>
                  <th><?= __('Amount','wpdmpp-sales-report')?> </th>
              </tr>
          </thead>
          <tbody>
              <tr>
                  <td><?= __('Today','wpdmpp-sales-report')?> </td>
                  <td><?php echo $this->var['total_orders_t']; ?></td>
                  <td><?php echo $this->currency . number_format($this->var['total_sales_t'],2,".",""); ?></td>
              </tr>
              <tr>
                  <td><?= __('Yesterday','wpdmpp-sales-report')?> </td>
                  <td><?php echo $yesterday['cnt']; ?></td>
                  <td><?php echo $this->currency . number_format($yesterday['total'],2,".",""); ?></td>
              </tr>
              <tr>
                  <td><?= __('Week','wpdmpp-sales-report')?> </td>
                  <td><?php echo $lastWeek['cnt']; ?></td>
                  <td><?php echo $this->currency . number_format($lastWeek['total'],2,".",""); ?></td>
              </tr>
              <tr>
                  <td><?= __('Month','wpdmpp-sales-report')?> </td>
                  <td><?php echo $lastMonth['cnt']; ?></td>
                  <td><?php echo $this->currency . number_format($lastMonth['total'],2,".",""); ?></td>
              </tr>
              <tr>
                  <td><?= __('Year','wpdmpp-sales-report')?> </td>
                  <td><?php echo $lastYear['cnt']; ?></td>
                  <td><?php echo $this->currency . number_format($lastYear['total'],2,".",""); ?></td>
              </tr>
          </tbody>
      </table>

  </div>
</div>

        <?php
    }

    private function orderStatus(){

        ?>
<div class="dm-card">
    <div class="dm-card-heading right-icons"><?= __('Sales Order Status','wpdmpp-sales-report')?>
        <div class="Icons">
            <a class="Table active" href="#" cls="table"><i class="fas fa-regular fa-table text-blue-300 text-xl"></i></a>
            <a class="BarChart" href="#" cls="barchart" fn="order_m_chart"><i class="fa-solid fa-chart-simple text-blue-300 text-xl"></i></a>
            <a class="PieChart" href="#" cls="piechart" fn="order_m_pie"><i class="fa-solid fa-chart-pie text-blue-300 text-xl"></i></a></a>
        </div>
    </div>
  <div class="dm-card-body p-0">
      <table class="table table-bordered table-striped">
          <thead>
              <tr>
                  <th><?= __('Order Status','wpdmpp-sales-report')?> </th>
                  <th><?= __('Order Count','wpdmpp-sales-report')?> </th>
                  <th><?= __('Amount','wpdmpp-sales-report')?> </th>
              </tr>
          </thead>
          <tbody>
  <?php
        if(!empty($this->var['order_status'])) {
            foreach ($this->var['order_status'] as $row){
                $row['total'] = number_format($row['total'],2,".","");
                echo "<tr><td>{$row['payment_status']}</td><td>{$row['cnt']}</td><td>{$this->currency}{$row['total']}</td></tr>";
            }
        }
        else {
            echo "<tr><td colspan='3'><?= __('No record found.','wpdmpp-sales-report')?> </td></tr>";
        }

  ?>
          </tbody>
      </table>

      <div class="barchart" id="orderBar" style="display:none;"></div>
      <div class="piechart" id="orderPie" style="display:none;"></div>

<script type="text/javascript">
function order_m_chart(){
    var payment = [<?php
        if(isset($this->var['order_status'])){
            $cnt = count($this->var['order_status']);
            $i = 1;
            foreach ($this->var['order_status'] as $row):
                echo "['{$row['payment_status']}',{$row['total']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("orderBar",[payment], {
            //title:'Sales By MOnth',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer:jQuery.jqplot.BarRenderer,
                rendererOptions: {
                    // Set the varyBarColor option to true to use different colors for each bar.
                    // The default series colors are used.
                    varyBarColor: true
                }
            },
            axes:{
                xaxis:{
                    renderer: jQuery.jqplot.CategoryAxisRenderer
                }
            }
        });
}

function order_m_pie(){
    var payment = [<?php
        if(isset($this->var['order_status'])){
            $cnt = count($this->var['order_status']);
            $i = 1;
            foreach ($this->var['order_status'] as $row):
                echo "['{$row['payment_status']}',{$row['total']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("orderPie",[payment], {
            //title:'Sales By MOnth',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer: jQuery.jqplot.PieRenderer,
                rendererOptions: {
                    showDataLabels: true
                }
            },
            legend:{ show:true }
        });
}


</script>
  </div>
</div>

        <?php
    }

    private function topProducts(){

        ?>
<div class="dm-card">
    <div class="dm-card-heading right-icons"><?= __('Top 5 Products','wpdmpp-sales-report')?>
        <div class="Icons">
            <a class="Table active" href="#" cls="table"><i class="fas fa-regular fa-table text-blue-300 text-xl"></i></a>
            <a class="BarChart" href="#" cls="barchart" fn="product_bar_chart"><i class="fa-solid fa-chart-simple text-blue-300 text-xl"></i></a>
            <a class="PieChart" href="#" cls="piechart" fn="product_pie_chart"><i class="fa-solid fa-chart-pie text-blue-300 text-xl"></i></a></a>
        </div>
    </div>
  <div class="dm-card-body p-0">
      <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th><?= __('Product ID','wpdmpp-sales-report')?> </th>
                <th><?= __('Title','wpdmpp-sales-report')?> </th>
                <th><?= __('Quantity','wpdmpp-sales-report')?> </th>
            </tr>
        <tbody>


      <?php
      if(!empty($this->var['top_products'])){
          foreach ($this->var['top_products'] as $pid => $data):
              echo "<tr><td>{$pid}</td><td>{$data['title']}</td><td>{$data['amount']}</td></tr>";
          endforeach;
      }

      else {
          echo "<tr><td colspan='3'>". __('No product found.','wpdmpp-sales-report')."</td></tr>";
      }
      ?>
        </tbody>
    </table>
      <div class="barchart" style="display: none;" id="product_bar_chart1"></div>
      <div class="piechart" style="display: none;" id="product_pie_chart1"></div>

<script type="text/javascript">
function product_pie_chart(){
    var topProd = [<?php
        if(isset($this->var['top_products'])){
            $cnt = count($this->var['top_products']);
            $i = 1;
            foreach ($this->var['top_products'] as $key => $val):
                if($val == "") $val = 0;
                //$val = intval($val);
                echo "['{$val['title']}',{$val['amount']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    //jQuery.jqplot.config.enablePlugins = true;
    plot2 = jQuery.jqplot("product_pie_chart1",[topProd], {
        title:'Top Products',
        animate: true,
        grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
        seriesDefaults:{
            renderer: jQuery.jqplot.PieRenderer,
            rendererOptions: {
                showDataLabels: true
            }
        },
        legend:{ show:true }
    });
}

function product_bar_chart(){
    var topProd = [<?php
        if(isset($this->var['top_products'])){
            $cnt = count($this->var['top_products']);
            $i = 1;
            foreach ($this->var['top_products'] as $key => $val):
                if($val == "") $val = 0;
                //$val = intval($val);
                echo "['{$val['title']}',{$val['amount']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    //jQuery.jqplot.config.enablePlugins = true;
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("product_bar_chart1",[topProd], {
            title:'Top Products',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer:jQuery.jqplot.BarRenderer,
                rendererOptions: {
                    // Set the varyBarColor option to true to use different colors for each bar.
                    // The default series colors are used.
                    varyBarColor: true
                }
            },
            axes:{
                xaxis:{
                    renderer: jQuery.jqplot.CategoryAxisRenderer
                }
            }
        });
}
</script>
  </div>
</div>

        <?php
    }

    private function topCustomer(){

        ?>
<div class="dm-card">
  <div class="dm-card-heading right-icons"><?= __('Top 5 Customers','wpdmpp-sales-report')?>
      <div class="Icons">
        <a class="Table active" href="#" cls="table"><i class="fas fa-regular fa-table text-blue-300 text-xl"></i></a>
        <a class="BarChart" href="#" cls="barchart" fn="customer_m_chart"><i class="fa-solid fa-chart-simple text-blue-300 text-xl"></i></a>
        <a class="PieChart" href="#" cls="piechart" fn="customer_m_pie"><i class="fa-solid fa-chart-pie text-blue-300 text-xl"></i></a></a>
    </div>
  </div>
  <div class="dm-card-body p-0">
      <table class="table table-bordered table-striped">
          <thead>
              <tr>
                  <th><?= __('Billing First Name','wpdmpp-sales-report')?> </th>
                  <th><?= __('Billing Email','wpdmpp-sales-report')?> </th>
                  <th><?= __('Order Count','wpdmpp-sales-report')?> </th>
                  <th><?= __('Amount','wpdmpp-sales-report')?> </th>
              </tr>
          </thead>
          <tbody>
          <?php
//                echo "<pre>"; print_r($this->var['top_customers']); echo "</pre>";
                $forChart = array();
                if($this->var['top_customers']):
                    foreach ($this->var['top_customers'] as $row):
                        $billing_shipping=maybe_unserialize(get_user_meta($row['uid'], 'user_billing_shipping',true));
                        $fname = wpdm_valueof( $billing_shipping, 'billing/first_name' );
                        $email = wpdm_valueof( $billing_shipping, 'billing/email' );
                        if($fname=='') $fname = "UID - " . $row['uid'];
                        $row['total'] = number_format($row['total'],2,".","");
                        $forChart[] = array('name' => $fname, 'total' => $row['total']);
                        unset($billing_shipping);
                        echo "<tr><td>{$fname}</td><td>{$email}</td><td>{$row['cnt']}</td><td>{$this->currency}{$row['total']}</td></tr>";
                    endforeach;

                else:
                    echo "<tr><td colspan='4'>" . __('No user found.','wpdmpp-sales-report')."</td></tr>";
                endif;
          ?>
          </tbody>
      </table>

      <div class="barchart" id="customerBar" style="display: none;"></div>
      <div class="piechart" id="customerPie" style="display: none;"></div>

<script type="text/javascript">
function customer_m_chart(){
    var payment = [<?php
        if(!empty($forChart)){
            $cnt = count($forChart);
            $i = 1;
            foreach ($forChart as $key => $row):
                echo "['{$row['name']}',{$row['total']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("customerBar",[payment], {
            //title:'Sales By MOnth',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer:jQuery.jqplot.BarRenderer,
                rendererOptions: {
                    // Set the varyBarColor option to true to use different colors for each bar.
                    // The default series colors are used.
                    varyBarColor: true
                }
            },
            axes:{
                xaxis:{
                    renderer: jQuery.jqplot.CategoryAxisRenderer
                }
            }
        });
}

function customer_m_pie(){
    var payment = [<?php
        if(!empty($forChart)){
            $cnt = count($forChart);
            $i = 1;
            foreach ($forChart as $key => $row):
                echo "['{$row['name']}',{$row['total']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("customerPie",[payment], {
            //title:'Sales By MOnth',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer: jQuery.jqplot.PieRenderer,
                rendererOptions: {
                    showDataLabels: true
                }
            },
            legend:{ show:true }
        });
}

</script>

  </div>
</div>

        <?php
    }

    private function topCoupons(){
//        $cnt = 0;
//        $temp = array();
//        $forChart = array();
//        wpdmdd($this->var['coupons']);
//        if(!empty($this->var['coupons'])):
//            foreach($this->var['coupons'] as $key => $coupon):
//                foreach ($coupon as $a => $b):
//                    if(is_numeric($b))
//                        $temp[$b][] = $a;
//
//                endforeach;
//            endforeach;
//
//        endif;
//
//        ?>
<div class="dm-card">
  <div class="dm-card-heading right-icons"><?= __('Top 5 Coupons','wpdmpp-sales-report')?>
      <div class="Icons">
            <a class="Table active" href="#" cls="table"><i class="fas fa-regular fa-table text-blue-300 text-xl"></i></a>
            <a class="BarChart" href="#" cls="barchart" fn="coupon_m_chart"><i class="fa-solid fa-chart-simple text-blue-300 text-xl"></i></a>
            <a class="PieChart" href="#" cls="piechart" fn="coupon_m_pie"><i class="fa-solid fa-chart-pie text-blue-300 text-xl"></i></a></a>
        </div>
  </div>
  <div class="dm-card-body p-0">
    <table class="table">
        <thead>
            <tr>
                <th><?= __('Coupon Code','wpdmpp-sales-report')?> </th>
                <th><?= __('Amount','wpdmpp-sales-report')?> </th>
            </tr>
        </thead>
        <tbody>

        <?php
//        wpdmdd($temp);
//        if(!empty($temp)):
//            foreach($temp as $price => $coupons):
//                    foreach ($coupons as $key => $c):
//                        $price = number_format($price,2,".","");
//                        echo "<tr><td>$c</td><td>". $this->currency ."$price</td></tr>";
//                        $forChart[] = array('coupon'=>$c, 'amount'=>$price);
//                        $cnt++;
//                        if($cnt==5) break;
//                    endforeach;
//
//            endforeach;
//        else:
//            echo "<tr><td colspan='2'>". __('No Coupons found...','wpdmpp-sales-report')." </td></tr>";
//        endif;
//        //print_r($forChart);
//        wpdmdd($this->var['top_coupons']);
        if(!empty($this->var['top_coupons'])) {
        foreach ($this->var['top_coupons'] as $row){
        $row['amount'] = number_format($row['amount'],2,".","");
        echo "<tr><td>{$row['coupon']}</td><td>{$this->currency}{$row['amount']}</td></tr>";
        $forChart[] = array('coupon' => $row['coupon'], 'amount' => $row['amount']);
        }
        }
        else {
            echo "<tr><td colspan='2'>". __('No Coupons found...','wpdmpp-sales-report')." </td></tr>";
        }

        ?>

        </tbody>
    </table>

      <div class="barchart" id="couponChart" style="display:none"></div>
      <div class="piechart" id="couponPie" style="display:none"></div>

<script type="text/javascript">
function coupon_m_chart(){
    var payment = [<?php
        if(!empty($forChart)){
            $cnt = count($forChart);
            $i = 1;
            foreach ($forChart as $key => $row):
                echo "['{$row['coupon']}',{$row['amount']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("couponChart",[payment], {
            //title:'Sales By MOnth',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer:jQuery.jqplot.BarRenderer,
                rendererOptions: {
                    // Set the varyBarColor option to true to use different colors for each bar.
                    // The default series colors are used.
                    varyBarColor: true
                }
            },
            axes:{
                xaxis:{
                    renderer: jQuery.jqplot.CategoryAxisRenderer
                }
            }
        });
}

function coupon_m_pie(){
    var payment = [<?php
        if(!empty($forChart)){
            $cnt = count($forChart);
            $i = 1;
            foreach ($forChart as $key => $row):
                echo "['{$row['coupon']}',{$row['amount']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("couponPie",[payment], {
            //title:'Sales By MOnth',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer: jQuery.jqplot.PieRenderer,
                rendererOptions: {
                    showDataLabels: true
                }
            },
            legend:{ show:true }
        });
}

</script>
  </div>
</div>

        <?php
    }

    private function topPaymentMethods(){

        ?>
<div class="dm-card">
  <div class="dm-card-heading right-icons"><?= __('Top 5 Payment Methods','wpdmpp-sales-report')?>
        <div class="Icons">
            <a class="Table active" href="#" cls="table"><i class="fas fa-regular fa-table text-blue-300 text-xl"></i></a>
            <a class="BarChart" href="#" cls="barchart" fn="payment_m_chart"><i class="fa-solid fa-chart-simple text-blue-300 text-xl"></i></a>
            <a class="PieChart" href="#" cls="piechart" fn="payment_m_pie"><i class="fa-solid fa-chart-pie text-blue-300 text-xl"></i></a></a>
        </div>
  </div>
  <div class="dm-card-body p-0">
    <table class="table table-bordered table-striped">
          <thead>
              <tr>
                  <th><?= __('Payment Method','wpdmpp-sales-report')?> </th>
                  <th><?= __('Order Count','wpdmpp-sales-report')?> </th>
                  <th><?= __('Amount','wpdmpp-sales-report')?> </th>
              </tr>
          </thead>
          <tbody>
  <?php
        if(!empty($this->var['top_payment_methods'])) {
            foreach ($this->var['top_payment_methods'] as $row){
                $row['total'] = number_format($row['total'],2,".","");
                echo "<tr><td>{$row['payment_method']}</td><td>{$row['cnt']}</td><td>{$this->currency}{$row['total']}</td></tr>";
            }
        }
        else {
            echo "<tr><td colspan='3'>". __('No record found.','wpdmpp-sales-report'). "</td></tr>";
        }

  ?>
          </tbody>
      </table>

      <div class="barchart" id="paymentBar" style="display:none;"></div>
      <div class="piechart" id="paymentPie" style="display:none;"></div>

<script type="text/javascript">
function payment_m_chart(){
    var payment = [<?php
        if(isset($this->var['top_payment_methods'])){
            $cnt = count($this->var['top_payment_methods']);
            $i = 1;
            foreach ($this->var['top_payment_methods'] as $row):
                echo "['{$row['payment_method']}',{$row['total']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("paymentBar",[payment], {
            //title:'Sales By MOnth',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer:jQuery.jqplot.BarRenderer,
                rendererOptions: {
                    // Set the varyBarColor option to true to use different colors for each bar.
                    // The default series colors are used.
                    varyBarColor: true
                }
            },
            axes:{
                xaxis:{
                    renderer: jQuery.jqplot.CategoryAxisRenderer
                }
            }
        });
}

function payment_m_pie(){
    var payment = [<?php
        if(isset($this->var['top_payment_methods'])){
            $cnt = count($this->var['top_payment_methods']);
            $i = 1;
            foreach ($this->var['top_payment_methods'] as $row):

                echo "['{$row['payment_method']}',{$row['total']}]";
                if($i<$cnt) echo ', ';
                $i++;
            endforeach;
        }
    ?>];
    jQuery.jqplot.config.enablePlugins = true;
       plot1 = jQuery.jqplot("paymentPie",[payment], {
            //title:'Sales By MOnth',
            animate: true,
            grid: {borderColor: 'transparent', shadow: false, drawBorder: false, shadowColor: 'transparent'},
            seriesDefaults:{
                renderer: jQuery.jqplot.PieRenderer,
                rendererOptions: {
                    showDataLabels: true
                }
            },
            legend:{ show:true }
        });
}


</script>
  </div>
</div>

        <?php
    }

    private function recentOrders(){
        global $wpdb;
        $sql = "SELECT order_id,`date`,total,uid,`order_status`,`payment_status` FROM `{$wpdb->prefix}ahm_orders` where order_status='Completed' ORDER BY `date` desc LIMIT 5";
        $results = $wpdb->get_results($sql,ARRAY_A);
    ?>
<div class="dm-card border-blue-500">
  <div class="dm-card-heading bg-blue-500 !text-white""><?= __('Recent 5 Orders','wpdmpp-sales-report')?> </div>
  <div class="dm-card-body p-0">
<!--      --><?php //echo "<pre>"; print_r($results); echo "</pre>"; ?>
      <div class="table-responsive">
      <table class="table table-bordered table-striped">
          <thead>
              <tr>
                  <th><?= __('Order ID','wpdmpp-sales-report')?> </th>
                  <th><?= __('Order Date','wpdmpp-sales-report')?> </th>
                  <th><?= __('Billing Email','wpdmpp-sales-report')?> </th>
                  <th><?= __('First Name','wpdmpp-sales-report')?> </th>
                  <th><?= __('Item Count','wpdmpp-sales-report')?> </th>
                  <th><?= __('Total','wpdmpp-sales-report')?> </th>
                  <th><?= __('Order Status','wpdmpp-sales-report')?> </th>
                  <th><?= __('Payment Status','wpdmpp-sales-report')?> </th>
              </tr>
          </thead>
          <tbody>
          <?php
                if($results):
                    foreach ($results as $row):

                        //$billing = maybe_unserialize($row['billing_shipping_data']);
//                        if($row['uid']>=0){
//                            $user_info = get_userdata($row['uid']);
//                        }
                        $user_info = get_userdata($row['uid']);
//                     echo "<pre>"; print_r($user_info); echo "</pre>";
                        $fname =  $user_info->last_name;
                        $email = $user_info->user_email;
//                        echo "<pre>"; print_r($email); echo "</pre>";
                        if (isset($row['cart_data'])) {
                            $cart_data = maybe_unserialize($row['cart_data']);
                            $cnt = count($cart_data);
                        }
                        if(!isset($cnt) ) $cnt = 0;
                        unset($cart_data);
                        $date = date('Y-m-d H:i:s', $row['date']);
                        $row['total'] = number_format($row['total'], 2, ".", "");
                        echo "<tr>
                                <td>{$row['order_id']}</td>
                                <td>$date</td>
                                <td>$email</td>
                                <td>$fname</td>
                                <td>$cnt</td>
                                <td>{$row['total']}</td>
                                <td>{$row['order_status']}</td>
                                <td>{$row['payment_status']}</td>
                            </tr>";
                    endforeach;

//                    foreach ($results as $row):
//                        //$billing = maybe_unserialize($row['billing_shipping_data']);
//                        $user_info = get_userdata($row['uid']);
//                        $fname =  $user_info->last_name;
//                        $email = $user_info->user_email;
//                        $cart_data = maybe_unserialize($row['cart_data']);
//                        $cnt = count($cart_data);
//                        unset($cart_data);
//                        $date = date('Y-m-d H:i:s',$row['date']);
//                        $row['total'] = number_format($row['total'],2,".","");
//                        echo "<tr>
//                            <td>{$row['order_id']}</td>
//                            <td>$date</td>
//                            <td>$email</td>
//                            <td>$fname</td>
//                            <td>$cnt</td>
//                            <td>{$row['total']}</td>
//                            <td>{$row['order_status']}</td>
//                            <td>{$row['payment_status']}</td>
//                                </tr>
//                            ";
//
//
//                    endforeach;
                else:
                    echo "<tr><td colspan='8'>". __('No order found.','wpdmpp-sales-report')."</td></tr>";
                endif;
          ?>
          </tbody>
      </table>
      </div>

  </div>
</div>

        <?php
    }
}

